/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_COMPUTE_FIBTRANS_H
#define MOO_COMPUTE_FIBTRANS_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_ext.h"
#include "moo_f2f.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define MOO_COMPUTE_FIBTRANS_ERROR_FLAG       1
#define MOO_COMPUTE_FIBTRANS_NORMALISE_THRESH 0.01
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_f2f *moo_compute_fibtrans(moo_ext *ext,
                              moo_compute_fibtrans_params *params,
                              const char *filename);

#endif
