/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_COMPUTE_LINEARITY_H
#define MOO_COMPUTE_LINEARITY_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_detlist.h"
#include "moo_loc.h"
#include "moo_cube.h"
#include "moo_bpm.h"
#include "moo_saturate_map.h"

#define MOO_DEBUG_COMPUTE_LINEARITY 0
#define CPL_COEFF_FIT               1

#define MOO_LINEARITY_TABLE_X           "x"
#define MOO_LINEARITY_TABLE_Y           "y"
#define MOO_LINEARITY_TABLE_TIME        "time"
#define MOO_LINEARITY_TABLE_FLUX        "flux"
#define MOO_LINEARITY_TABLE_ERR         "err"
#define MOO_LINEARITY_TABLE_MSE         "mse"
#define MOO_LINEARITY_TABLE_ILLUMINATED "illuminated"
#define MOO_LINEARITY_TABLE_C0          "c0"
#define MOO_LINEARITY_TABLE_C1          "c1"

#define MOO_LINEARITY_TABLE_D0   "d0"
#define MOO_LINEARITY_TABLE_D1   "d1"
#define MOO_LINEARITY_TABLE_D2   "d2"
#define MOO_LINEARITY_TABLE_DMSE "dmse"

#define MOO_COMPUTE_LINEARITY_DEGREE 3
moo_saturate_map *moo_compute_saturate_pixels(moo_detlist *detlist,
                                              moo_loc *loc,
                                              moo_linear_params *params);

moo_cube *moo_compute_linearity(moo_detlist *detlist,
                                moo_loc *loc,
                                moo_saturate_map *saturate_map,
                                const char *cube_filename);

moo_bpm *moo_compute_bpm_linearity(moo_cube *cube,
                                   moo_loc *loc,
                                   moo_saturate_map *saturate_map,
                                   moo_linear_params *params,
                                   const char *bpm_name);

#endif
