/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_CORRECT_TELL_H
#define MOO_CORRECT_TELL_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_rbn.h"
#include "moo_telluric.h"

#define MOO_DEBUG_CORRECT_TELL  1
#define MOO_CORRECT_TELL_LAMBDA "lambda"
#define MOO_CORRECT_TELL_FLUX   "flux"
#define MOO_CORRECT_TELL_DFLUX  "dflux"
#define MOO_CORRECT_TELL_MASK   "mask"
#define MOO_CORRECT_TELL_CFLUX  "cflux"
#define MOO_CORRECT_TELL_CDFLUX "cdflux"
#define MOO_CORRECT_TELL_QUAL   "qual"
#define MOO_CORRECT_TELL_MTRANS "mtrans"

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code moo_correct_tell(moo_rbn *rbn, moo_telluric *tell);
cpl_error_code moo_correct_tell_science(moo_sci *sci, moo_telluric *tell);
#endif
