/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_DETECTOR_H
#define MOO_DETECTOR_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>

/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/**@{*/
/**
 * @ingroup moo_detector
 *
 * @brief the different type of detectors
 */
enum _moo_detector_type_
{
    /* type */

    /**
     * RI detector type
     */
    MOO_TYPE_RI,
    /**
     * YJ detector type
     */
    MOO_TYPE_YJ,
    /**
     * H detector type
     */
    MOO_TYPE_H
};

/**
 * @ingroup moo_detector
 *
 * @brief
 *   The type code type.
 */

typedef enum _moo_detector_type_ moo_detector_type;

enum _moo_mode_type_
{
    /* type */

    /**
     * LR mode
     */
    MOO_MODE_LR,
    /**
     * HR mode
     */
    MOO_MODE_HR
};

typedef enum _moo_mode_type_ moo_mode_type;

#define MOO_CHANNEL_RI_NAME "RI"
#define MOO_CHANNEL_YJ_NAME "YJ"
#define MOO_CHANNEL_H_NAME  "H"

#define MOO_SPECTRO1 1
#define MOO_SPECTRO2 2

#define MOO_DETECTOR_RI1_NAME "RI_1"
#define MOO_DETECTOR_RI2_NAME "RI_2"
#define MOO_DETECTOR_YJ1_NAME "YJ_1"
#define MOO_DETECTOR_YJ2_NAME "YJ_2"
#define MOO_DETECTOR_H1_NAME  "H_1"
#define MOO_DETECTOR_H2_NAME  "H_2"

#define MOO_MODE_LR_NAME "LR"
#define MOO_MODE_HR_NAME "HR"

#define MOO_QUAL                  "QUAL"
#define MOO_ERR                   "ERR"
#define MOO_EXTNAME(prefix, name) prefix "_" name

/**@}*/

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
const char *moo_detector_get_err_extname(moo_detector_type type, int ntas);
const char *moo_detector_get_qual_extname(moo_detector_type type, int ntas);
const char *moo_detector_get_extname(moo_detector_type type, int ntas);
int moo_detector_get_spectro(int ntas);
const char *moo_detector_get_name(moo_detector_type type);

const char *moo_mode_get_name(moo_mode_type type);
moo_mode_type moo_mode_get(const cpl_frame *frame);
int moo_offset_get(const cpl_frame *refframe);
#endif
