/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_DETLIST_H
#define MOO_DETLIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_det.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */
typedef struct
{
    moo_det **list;
    cpl_size size;
} moo_detlist;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_detlist *moo_detlist_new(void);
moo_detlist *moo_detlist_create(cpl_frameset *frameset);
cpl_size moo_detlist_get_size(const moo_detlist *self);

cpl_error_code moo_detlist_set(moo_detlist *self, moo_det *det, cpl_size pos);

cpl_error_code moo_detlist_push(moo_detlist *self, moo_det *det);

moo_det *moo_detlist_unset(moo_detlist *self, cpl_size pos);
void moo_detlist_empty(moo_detlist *self);
void moo_detlist_delete(moo_detlist *self);
moo_det *moo_detlist_get(moo_detlist *self, int i);

cpl_error_code moo_detlist_load_single(const moo_detlist *self,
                                       moo_detector_type type,
                                       int num,
                                       int level);
cpl_error_code moo_detlist_free_single(const moo_detlist *self,
                                       moo_detector_type type,
                                       int num);

hdrl_imagelist *
moo_detlist_get_image(const moo_detlist *self, moo_detector_type type, int num);

cpl_imagelist *moo_detlist_get_single_data(const moo_detlist *self,
                                           moo_detector_type type,
                                           int num);
cpl_imagelist *moo_detlist_get_single_qual(const moo_detlist *self,
                                           moo_detector_type type,
                                           int num);

#endif
