/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_EXTLIST_H
#define MOO_EXTLIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_ext.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */
typedef struct
{
    moo_ext **list;
    cpl_size size;
} moo_extlist;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_extlist *moo_extlist_new(void);
moo_extlist *moo_extlist_create(cpl_frameset *frameset);
cpl_size moo_extlist_get_size(const moo_extlist *self);

cpl_error_code moo_extlist_set(moo_extlist *self, moo_ext *ext, cpl_size pos);

cpl_error_code moo_extlist_push(moo_extlist *self, moo_ext *ext);

moo_ext *moo_extlist_unset(moo_extlist *self, cpl_size pos);
void moo_extlist_empty(moo_extlist *self);
void moo_extlist_delete(moo_extlist *self);
moo_ext *moo_extlist_get(moo_extlist *self, int i);
moo_ext *moo_extlist_sum(moo_extlist *self, const char *filename);

cpl_error_code moo_extlist_load_single(const moo_extlist *self,
                                       moo_detector_type type,
                                       int num,
                                       int level);
cpl_error_code moo_extlist_free_single(const moo_extlist *self,
                                       moo_detector_type type,
                                       int num);

hdrl_imagelist *
moo_extlist_get_image(const moo_extlist *self, moo_detector_type type, int num);

cpl_imagelist *moo_extlist_get_single_data(const moo_extlist *self,
                                           moo_detector_type type,
                                           int num);
cpl_imagelist *moo_extlist_get_single_qual(const moo_extlist *self,
                                           moo_detector_type type,
                                           int num);
#endif
