/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_LINE_TABLE_H
#define MOO_LINE_TABLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"

#define MOO_PPM_TABLE_WAVE     "WAVE"
#define MOO_PPM_TABLE_X        "X"
#define MOO_PPM_TABLE_INDEXEXT "INDEXEXT"
#define MOO_PPM_TABLE_DISP     "DISP"

#define MOO_LINE_TABLE_EXTNAME    "LINE_TABLE"
#define MOO_LINE_TABLE_NAME       "NAME"
#define MOO_LINE_TABLE_WAVE       "WAVE"
#define MOO_LINE_TABLE_FLUX       "FLUX"
#define MOO_LINE_TABLE_XGUESS     "XGUESS"
#define MOO_LINE_TABLE_SPECTRO    "SPECTRO"
#define MOO_LINE_TABLE_DETECTOR   "DETECTOR"
#define MOO_LINE_TABLE_SLITLET    "SLITLET"
#define MOO_LINE_TABLE_INDEXEXT   "INDEXEXT"
#define MOO_LINE_TABLE_INDEXRBN   "INDEXRBN"
#define MOO_LINE_TABLE_INTENSITY  "INTENSITY"
#define MOO_LINE_TABLE_XGAUSS     "XGAUSS"
#define MOO_LINE_TABLE_XBARY      "XBARY"
#define MOO_LINE_TABLE_DISP       "DISP"
#define MOO_LINE_TABLE_XDIFF      "XDIFF"
#define MOO_LINE_TABLE_WAVEDIFF   "WAVEDIFF"
#define MOO_LINE_TABLE_YLOC       "YLOC"
#define MOO_LINE_TABLE_FWHM       "FWHM"
#define MOO_LINE_TABLE_AMPLITUDE  "AMPLITUDE"
#define MOO_LINE_TABLE_BACKGROUND "BACKGROUND"
#define MOO_LINE_TABLE_FIT_CHI2   "FIT_CHI2"
#define MOO_LINE_TABLE_FIT_MSE    "FIT_MSE"
#define MOO_LINE_TABLE_FIT_FLUX   "FIT_FLUX"
#define MOO_LINE_TABLE_FIT_ERR    "FIT_ERR"
#define MOO_LINE_TABLE_GFITTED    "GFITTED"
#define MOO_LINE_TABLE_FILTERED   "FILTERED"
#define MOO_LINE_TABLE_MATCHED    "MATCHED"
#define MOO_LINE_TABLE_MFITTED    "MFITTED"
#define MOO_LINE_TABLE_WAVEFIT    "WAVEFIT"
#define MOO_LINE_TABLE_RESOLUTION "RESOLUTION"

#define MOO_DETECTED_TABLE_MIN            "MIN"
#define MOO_DETECTED_TABLE_MAX            "MAX"
#define MOO_DETECTED_TABLE_TRESHOLD       "THRESHOLD"
#define MOO_DETECTED_TABLE_NITER          "NITER"
#define MOO_DETECTED_TABLE_WIN_MIN        "WIN_MIN"
#define MOO_DETECTED_TABLE_WIN_MAX        "WIN_MAX"
#define MOO_DETECTED_TABLE_WIN_CEN        "WIN_CEN"
#define MOO_DETECTED_TABLE_BADDETECT      "BADDETECT"
#define MOO_DETECTED_TABLE_NGOOD          "NGOOD"
#define MOO_DETECTED_TABLE_WAVETH         "WAVETH"
#define MOO_DETECTED_TABLE_BADFIT         "BADFIT"
#define MOO_DETECTED_TABLE_FIT_MSE        "FIT_MSE"
#define MOO_DETECTED_TABLE_FIT_CHI2       "FIT_CHI2"
#define MOO_DETECTED_TABLE_FIT_FLUX       "FIT_FLUX"
#define MOO_DETECTED_TABLE_FIT_ERR        "FIT_ERR"
#define MOO_DETECTED_TABLE_FIT_BACKGROUND "FIT_BACKGROUND"
#define MOO_DETECTED_TABLE_NOT_IN_RANGE   "BADRANGE"

#define MOO_SLITLET_SHIFT_TABLE_SLITLET "SLITLET"
#define MOO_SLITLET_SHIFT_TABLE_WAVE    "WAVE"
#define MOO_SLITLET_SHIFT_TABLE_XDIFF   "XDIFF"

cpl_table *moo_slitlet_shift_table_new(int size);
cpl_table *moo_detected_table_new(int size, int isGuess);

cpl_table *moo_line_table_new(int isGuess);
cpl_table *moo_line_table_load(cpl_frame *wmap);
cpl_error_code
moo_table_append(cpl_table *global_line_table, cpl_table *line_table);
#endif
