/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_LOC_H
#define MOO_LOC_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_loc_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    char *filename;
    cpl_propertylist *primary_header;
    moo_loc_single *ri[2];
    moo_loc_single *yj[2];
    moo_loc_single *h[2];
    cpl_table *fibre_table;
} moo_loc;

#define MOO_LOC_CRPIX1 1
#define MOO_LOC_CRVAL1 1
#define MOO_LOC_CD1_1  1.
#define MOO_LOC_CTYPE1 "PIXELS"
#define MOO_LOC_CRPIX2 1
#define MOO_LOC_CRVAL2 1
#define MOO_LOC_C2_2   1.
#define MOO_LOC_CTYPE2 "INDEX"
#define MOO_LOC_BUNIT  "pixels"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_loc *moo_loc_new(void);
cpl_error_code moo_loc_set_single(moo_loc *self,
                                  moo_detector_type type,
                                  int ntas,
                                  moo_loc_single *s);
moo_loc *moo_loc_create(const char *filename);

moo_loc *moo_loc_load(const cpl_frame *locframe);
moo_loc_single *
moo_loc_get_single(moo_loc *self, moo_detector_type type, int num);

cpl_error_code moo_loc_add_single(moo_loc *self,
                                  moo_loc_single *s,
                                  moo_detector_type type,
                                  int ntas,
                                  int keep_points);
cpl_error_code moo_loc_add_fibre_table(moo_loc *self, cpl_table *fibre_table);

cpl_table *moo_loc_get_fibre_table(moo_loc *self);
void moo_loc_delete(moo_loc *self);
void moo_loc_save(moo_loc *self, const char *filename, int keep_points);
cpl_error_code moo_loc_dump(const moo_loc *self, FILE *stream);
#endif
