/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_LOC_SINGLE_H
#define MOO_LOC_SINGLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>


#define MOO_LOC_SINGLE_FCENTROID "LOC_FIT"
#define MOO_LOC_SINGLE_MCENTROID "LOC_PTS"
#define MOO_LOC_SINGLE_WLO       "WIDTH_LOW"
#define MOO_LOC_SINGLE_WUP       "WIDTH_UP"
#define MOO_LOC_SINGLE_MWLO      "PTS_WIDTH_LOW"
#define MOO_LOC_SINGLE_MWUP      "PTS_WIDTH_UP"
#define MOO_LOC_SINGLE_FLAGS     "FLAGS"

#define MOONS_FLAG_GOOD                 0
#define MOONS_FLAG_YDIFF_OUTLIERS       1
#define MOONS_FLAG_WDIFF_OUTLIERS       2
#define MOONS_FLAG_BADPROFILE           3
#define MOONS_FLAG_BADPIX               4
#define MOONS_FLAG_NON_SIGNIFICANT_FLUX 5
#define MOONS_FLAG_NOPROFILE            6
#define MOONS_FLAG_NAN_IN_TRACE_GUESS   7
#define MOONS_FLAG_NARROWPROFILE        8
#define MOONS_FLAG_BROKEN_FIBRE         9
#define MOONS_FLAG_XMAX_GAP             10
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    const char *filename;
    const char *extname;
    cpl_propertylist *header;
    cpl_image *m_centroids;
    cpl_image *f_centroids;
    cpl_image *f_wlow;
    cpl_image *f_wup;
    cpl_image *m_wup;
    cpl_image *m_wlow;
    cpl_image *flags;
} moo_loc_single;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_loc_single *moo_loc_single_new(void);
moo_loc_single *
moo_loc_single_create(const char *filename, const char *extname);

cpl_propertylist *moo_loc_single_get_header(moo_loc_single *self);
cpl_image *moo_loc_single_get_f_centroids(moo_loc_single *self);
double moo_loc_single_eval_f_centroids(moo_loc_single *self,
                                       double x,
                                       int indexext,
                                       int *rej);
cpl_image *moo_loc_single_get_m_centroids(moo_loc_single *self);
cpl_image *moo_loc_single_get_flags(moo_loc_single *self);
cpl_image *moo_loc_single_get_f_wlo(moo_loc_single *self);
cpl_image *moo_loc_single_get_f_wup(moo_loc_single *self);
cpl_mask *moo_loc_single_get_ODR(moo_loc_single *self, int size_y);

cpl_error_code
moo_loc_single_compute_qc_guess(moo_loc_single *self, int deg_poly);
cpl_error_code moo_loc_single_compute_qc_trace(moo_loc_single *self,
                                               int deg_poly,
                                               moo_loc_single *guess);

void moo_loc_single_delete(moo_loc_single *self);
void moo_loc_single_save(const moo_loc_single *self,
                         const char *filename,
                         int keep_points);
cpl_error_code moo_loc_single_dump(const moo_loc_single *self, FILE *stream);

#endif
