/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_MODELFLAT_H
#define MOO_MODELFLAT_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_det.h"
#include "moo_loc.h"
#include "moo_psf.h"

#define MOO_DEBUG_MODEL_FLAT 0

typedef struct
{
    double sigma;
    double cexp;
    double A;
    double c0;
    double b;
} moo_model;


moo_psf *moo_model_flat(moo_det *det,
                        moo_loc *loc,
                        moo_model_flat_params *params,
                        const char *filename);

moo_model *
moo_model_new(double sigma, double cexp, double A, double c0, double b);
void moo_model_delete(moo_model *self);
double moo_model_eval(moo_model *self, double x);
double moo_model_dA_eval(moo_model *self, double x);
double moo_model_dsigma_eval(moo_model *self, double x);
double moo_model_dcexp_eval(moo_model *self, double x);
double moo_model_dc0_eval(moo_model *self, double x);
#endif
