/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_MOLECTABLE_H
#define MOO_MOLECTABLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_fits.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    cpl_propertylist *primary_header;
    char *filename;
    cpl_table *data[3];
    cpl_propertylist *data_header[3];
    const char *mode;
} moo_molectable;


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_molectable *moo_molectable_new(void);
moo_molectable *
moo_molectable_load(const cpl_frame *frame, const char *modename);
cpl_table *
moo_molectable_get_data(moo_molectable *self, moo_detector_type type);
cpl_error_code moo_molectable_set_data(moo_molectable *self,
                                       moo_detector_type type,
                                       cpl_table *data);
void moo_molectable_save(moo_molectable *self, const char *filename);
void moo_molectable_delete(moo_molectable *self);

#endif
