/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_PSF_H
#define MOO_PSF_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_psf_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
typedef struct
{
    cpl_propertylist *primary_header;
    char *filename;
    moo_psf_single *ri[2];
    moo_psf_single *yj[2];
    moo_psf_single *h[2];
    /*cpl_table* fibre_table;*/
} moo_psf;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_psf *moo_psf_new(void);
cpl_error_code moo_psf_set_single(moo_psf *self,
                                  moo_detector_type type,
                                  int ntas,
                                  moo_psf_single *s);
moo_psf *moo_psf_create(const char *filename);

moo_psf *moo_psf_load(const cpl_frame *psfframe);
moo_psf_single *
moo_psf_get_single(moo_psf *self, moo_detector_type type, int num);
cpl_error_code moo_psf_add_single(moo_psf *self,
                                  moo_psf_single *s,
                                  moo_detector_type type,
                                  int ntas);

void moo_psf_delete(moo_psf *self);
void moo_psf_save(moo_psf *self, const char *filename);
cpl_error_code moo_psf_dump(const moo_psf *self, FILE *stream);
#endif
