/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_PSF_SINGLE_H
#define MOO_PSF_SINGLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_single.h"
#include "moo_loc_single.h"
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define MOO_PSF_SINGLE_PREFIX_EXTNAME "FF2D"
#define MOO_PSF_SINGLE_CUNIT1         "pixel"

typedef struct
{
    const char *filename;
    const char *extname;
    cpl_imagelist *cube;
    cpl_propertylist *header;
} moo_psf_single;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_psf_single *moo_psf_single_new(void);

moo_psf_single *
moo_psf_single_create(const char *filename, const char *extname);
cpl_error_code
moo_psf_single_set_cube_ref(moo_psf_single *self, double crpix2, double cd2_2);
cpl_imagelist *moo_psf_single_get_cube(moo_psf_single *self);
cpl_error_code moo_psf_single_get_cube_ref(moo_psf_single *self,
                                           double *crpix2,
                                           double *cd2_2);
cpl_error_code moo_psf_single_normalize(moo_psf_single *self);

cpl_image *moo_psf_single_reproject_model(moo_psf_single *self,
                                          moo_single *det,
                                          moo_loc_single *loc,
                                          const int *health,
                                          cpl_array *indexes);
void moo_psf_single_delete(moo_psf_single *self);
cpl_error_code moo_psf_single_dump(const moo_psf_single *self, FILE *stream);
void moo_psf_single_save(const moo_psf_single *self, const char *filename);
void moo_psf_single_delete(moo_psf_single *self);
#endif
