/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_RAW_H
#define MOO_RAW_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_single.h"


/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
/* detector structure */
typedef struct
{
    cpl_propertylist *header;
    cpl_image *data;
} moo_raw_ext;

typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    moo_raw_ext *ri[2];
    moo_raw_ext *yj[2];
    moo_raw_ext *h[2];
} moo_raw;
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

moo_raw *moo_raw_new(void);
moo_raw *moo_raw_create(const cpl_frame *frame);
void moo_raw_delete(moo_raw *self);
cpl_error_code moo_raw_save(moo_raw *self, const char *filename);
cpl_error_code moo_raw_avg(moo_raw *a, moo_raw *b);

#endif
