/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_REBIN_H
#define MOO_REBIN_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_det.h"
#include "moo_map.h"
#include "moo_spectral_format.h"
#include "moo_ext.h"
#include "moo_loc.h"
#include "moo_rbn.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/
#define MOO_DEBUG_REBIN  0
#define MOO_REBIN_CTYPE1 "WAVE"
#define MOO_REBIN_CUNIT1 "nm"

#define MOO_REBIN_REFTABLE_WAVE "WAVE"
#define MOO_REBIN_REFTABLE_X    "X"
#define MOO_REBIN_REFTABLE_Y    "NUMFIB"
#define MOO_REBIN_REFTABLE_FLUX "FLUX"
#define MOO_REBIN_REFTABLE_ERR  "ERR"
#define MOO_REBIN_REFTABLE_QUAL "QUAL"

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_rbn *moo_rebin(moo_ext *ext,
                   moo_map *wavemap,
                   moo_spectral_format *sformat,
                   moo_rebin_params *params,
                   const char *filename);

#endif
