/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_REGION_H
#define MOO_REGION_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"

#define MOO_REGION_LAYOUT_LLX "LLX"
#define MOO_REGION_LAYOUT_LLY "LLY"
#define MOO_REGION_LAYOUT_URX "URX"
#define MOO_REGION_LAYOUT_URY "URY"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/

typedef struct
{
    int xb;
    int yb;
    int xu;
    int yu;
} moo_region;

typedef struct
{
    moo_region **list;
    int size;
} moo_regionlist;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_region *moo_region_new(void);
moo_region *moo_region_load(const char *value);
void moo_region_delete(moo_region *self);
void moo_region_dump(moo_region *self);

moo_regionlist *moo_regionlist_new(int size);
void moo_regionlist_delete(moo_regionlist *self);
moo_regionlist *moo_regionlist_load(const char *value);
moo_regionlist *moo_regionlist_load_layout(const cpl_frame *layout_frame,
                                           moo_detector_type type,
                                           int ntas);
void moo_regionlist_dump(moo_regionlist *self);
#endif
