/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_RESP_H
#define MOO_RESP_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_scilist.h"
/**
 * @ingroup moo_resp
 *
 * @brief RESPONSE format
 */

#define MOO_RESP_EXT_RI             "RI"
#define MOO_RESP_EXT_YJ             "YJ"
#define MOO_RESP_EXT_H              "H"
#define MOO_RESP_EXT_RESPONSE_TABLE "STANDARD_TABLE"
#define MOO_RESP_TABLE_INDEXRBN     "INDEXRBN"
#define MOO_RESP_TABLE_SPECTRO      "SPECTRO"
#define MOO_RESP_TABLE_RESPONSE     "RESPONSE"
#define MOO_RESP_WAVE               "WAVE"
#define MOO_RESP_RESPONSE           "RESPONSE"
#define MOO_RESP_SPECFLUX           "SPECFLUX"
#define MOO_RESP_SPECFLUXFILTER     "SPECFLUXFILTER"
#define MOO_RESP_ATM                "ATM"
#define MOO_RESP_FLX                "FLX"

#define MOO_DEBUG_RESP 0

typedef struct
{
    cpl_propertylist *primary_header;
    cpl_table *ri;
    cpl_table *yj;
    cpl_table *h;
    cpl_table *response_table;
} moo_resp;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_resp *moo_resp_new(void);
moo_resp *moo_resp_create(moo_scilist *scilist, int badpix_level);
void moo_resp_delete(moo_resp *resp);
cpl_error_code
moo_resp_set_table(moo_resp *self, moo_detector_type type, cpl_table *t);
cpl_table *moo_resp_get_table(moo_resp *self, moo_detector_type type);
const char *moo_resp_get_colname(moo_resp *self, int idrbn, int spectro);
void moo_resp_save(moo_resp *self, const char *filename);
moo_resp *moo_resp_load(const cpl_frame *frame);
#endif
