/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SKY_LINES_LIST_H
#define MOO_SKY_LINES_LIST_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <hdrl.h>
#include "moo_detector.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/

#define MOO_SKY_LINES_LIST_LINECAT_HR_TNAME "LINE_CATALOG_HR"
#define MOO_SKY_LINES_LIST_FREEZONE_TNAME   "OH_FREE_ZONES"

#define MOO_SKY_LINES_LIST_WAVE_COLNAME "WAVE"
#define MOO_SKY_LINES_LIST_NAME_COLNAME "NAME"
#define MOO_SKY_LINES_LIST_FLUX_COLNAME "FLUX"
#define MOO_SKY_LINES_LIST_BAND_COLNAME "BAND"

#define MOO_SKY_LINES_LIST_WMIN_COLNAME "WAVE_MIN"
#define MOO_SKY_LINES_LIST_WMAX_COLNAME "WAVE_MAX"

typedef struct
{
    char *filename;
    cpl_table *linecat;
    cpl_table *free_zones;

} moo_sky_lines_list;


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_sky_lines_list *moo_sky_lines_list_new(void);

moo_sky_lines_list *moo_sky_lines_list_load(const cpl_frame *frame);

cpl_error_code moo_sky_lines_list_get_free_zones(moo_sky_lines_list *self,
                                                 double wmin,
                                                 double wmax,
                                                 double **zwmin,
                                                 double **zwmax,
                                                 cpl_array **sel);

void moo_sky_lines_list_delete(moo_sky_lines_list *self);

#endif
