/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SKYCORR_H
#define MOO_SKYCORR_H

#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"

#define MOO_SC_FWHM       5.0
#define MOO_SC_VARFWHM    0

#define MOO_DEBUG_SKYCORR 0
/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
cpl_error_code moo_skycorr(hdrl_image *rbn,
                           hdrl_image *sky,
                           int indextarg,
                           int indexrbn,
                           double crpix1,
                           double crval1,
                           double cd1_1,
                           cpl_propertylist *header,
                           const cpl_frame *solflux_frame,
                           const cpl_frame *airglow_group_frame,
                           const cpl_frame *airglow_var_frame,
                           moo_skycorr_params *params,
                           hdrl_image *sci,
                           cpl_image *sci_sky);
//char* moo_string_encode(const char* s);
#endif
