/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_SUB_SKY_STARE_H
#define MOO_SUB_SKY_STARE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_rbn.h"
#include "moo_target_table.h"
#include "moo_f2f.h"
#include "moo_sci.h"

#define MOO_DEBUG_SKY 0

#define MOO_SKY_STARE_INDEXTARG   "INDEXTARG"
#define MOO_SKY_STARE_TARGNAME    "TARGNAME"
#define MOO_SKY_STARE_INDEXRBN    "INDEXRBN"
#define MOO_SKY_STARE_SKYINDEXRBN "SKY_INDEXRBN"
#define MOO_SKY_STARE_SKYDSLIT    "SKY_DSLIT"
#define MOO_SKY_STARE_SKYTRANS    "SKY_TRANS"
#define MOO_SKY_STARE_RADIUS      "RADIUS"
#define MOO_SKY_STARE_SKYDIST     "SKY_DISTANCE"

#define MOO_SCI1D_NOT_PAIRED 0
#define MOO_SCI1D_PAIRED     1
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_sci *moo_sub_sky_stare(moo_rbn *rbn,
                           moo_target_table *target_table,
                           moo_rbn *sky_rbn,
                           moo_f2f *f2f,
                           const cpl_frame *solflux_frame,
                           const cpl_frame *airglow_group_frame,
                           const cpl_frame *airglow_var_frame,
                           moo_sub_sky_stare_params *params,
                           const char *filename,
                           int ispaired);

cpl_array *moo_select_sky(const char *targname,
                          int indextarg,
                          int indexrbn,
                          double obj_targalpha,
                          double obj_targdelta,
                          cpl_table *target_table,
                          const char *index_colname,
                          cpl_table *sky_stare_table,
                          moo_detector_type type,
                          int maxdistslit,
                          double mintrans,
                          int min_sky,
                          double radius,
                          double step_r,
                          int target_table_idx,
                          moo_f2f *f2f,
                          cpl_array *allsky_indexes);
#endif
