/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_TARGET_TABLE_H
#define MOO_TARGET_TABLE_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_rbn.h"
#include "moo_ext.h"
#include "moo_map.h"
#include "moo_sky_lines_list.h"

#define MOO_TARGET_TABLE_INDEXTARG      "INDEXTARG"
#define MOO_TARGET_TABLE_TARGNAME       "TARGNAME"
#define MOO_TARGET_TABLE_TARGALPHA      "TARGALPHA"
#define MOO_TARGET_TABLE_TARGDELTA      "TARGDELTA"
#define MOO_TARGET_TABLE_TYPE           "TYPE"
#define MOO_TARGET_TABLE_TYPENOD        "TYPE_NOD"
#define MOO_TARGET_TABLE_FIBRE          "FIBRE"
#define MOO_TARGET_TABLE_INDEX          "INDEX"
#define MOO_TARGET_TABLE_PAIREDFIBRE    "PAIREDFIBRE"
#define MOO_TARGET_TABLE_INDEXRBN       "INDEXRBN"
#define MOO_TARGET_TABLE_PAIREDINDEXRBN "PAIREDINDEXRBN"
#define MOO_TARGET_TABLE_OBSTYPE        "OBSTYPE"
#define MOO_TARGET_TABLE_SUBSKYMODE     "SUBSKYMODE"
#define MOO_TARGET_TABLE_SUBSKY_NOD     "NOD"
#define MOO_TARGET_TABLE_SUBSKY_STARE   "STARE"
#define MOO_TARGET_TABLE_SUBSKY_MIXED   "MIXED"
#define MOO_TARGET_TABLE_SPECTRO        "SPECTRO"

#define MOO_OBSTYPE_SKYSTARE       "SKY_STARE"
#define MOO_OBSTYPE_OBSSTARE       "OBS_STARE"
#define MOO_OBSTYPE_SKYRESSTARE    "SKYRES_STARE"
#define MOO_OBSTYPE_SKYRESPSTARE   "SKYRES_P_STARE"
#define MOO_OBSTYPE_OBSPSTARE      "OBS_P_STARE"
#define MOO_OBSTYPE_OBSNOD         "OBS_NOD"
#define MOO_OBSTYPE_SKYRESNOD      "SKYRES_NOD"
#define MOO_OBSTYPE_OBSSWITCH      "OBS_SWITCH"
#define MOO_OBSTYPE_OBSSWITCHSTARE "OBS_SWITCHSTARE"
#define MOO_OBSTYPE_OBSNODSTARE    "OBS_NODSTARE"

#define MOO_OBSTYPE_OBSPNOD      "OBS_P_NOD"
#define MOO_OBSTYPE_OBSPNODSTARE "OBS_P_NODSTARE"

#define MOO_TARGET_TABLE_EXPTIMERI "EXPTIMERI"
#define MOO_TARGET_TABLE_EXPTIMEYJ "EXPTIMEYJ"
#define MOO_TARGET_TABLE_EXPTIMEH  "EXPTIMEH"

#define MOO_TARGET_TABLE_MAG "MAG"

#define MOO_TARGET_TABLE_NBSKY          "NSKY_FIBRES"
#define MOO_TARGET_TABLE_MAX_DIST_SLIT  "MAX_DIST_SLIT"
#define MOO_TARGET_TABLE_MAX_DIST_SKY   "MAX_DIST_SKY"
#define MOO_TARGET_TABLE_PNBSKY         "PNSKY_FIBRES"
#define MOO_TARGET_TABLE_PMAX_DIST_SLIT "PMAX_DIST_SLIT"
#define MOO_TARGET_TABLE_PMAX_DIST_SKY  "PMAX_DIST_SKY"

#define MOO_TARGET_TABLE_TRANSRI  "TRANSRI"
#define MOO_TARGET_TABLE_TRANSYJ  "TRANSYJ"
#define MOO_TARGET_TABLE_TRANSH   "TRANSH"
#define MOO_TARGET_TABLE_PTRANSRI "PTRANSRI"
#define MOO_TARGET_TABLE_PTRANSYJ "PTRANSYJ"
#define MOO_TARGET_TABLE_PTRANSH  "PTRANSH"

#define MOO_TARGET_TABLE_MEDSNRRI_EXT "MEDIAN_SNR_RI_EXT"
#define MOO_TARGET_TABLE_MEDSNRYJ_EXT "MEDIAN_SNR_YJ_EXT"
#define MOO_TARGET_TABLE_MEDSNRH_EXT  "MEDIAN_SNR_H_EXT"

#define MOO_TARGET_TABLE_DERSNRRI_EXT "DERSNR_RI_EXT"
#define MOO_TARGET_TABLE_DERSNRYJ_EXT "DERSNR_YJ_EXT"
#define MOO_TARGET_TABLE_DERSNRH_EXT  "DERSNR_H_EXT"

#define MOO_TARGET_TABLE_MEDSNRRI_RBN "MEDIAN_SNR_RI_RBN"
#define MOO_TARGET_TABLE_MEDSNRYJ_RBN "MEDIAN_SNR_YJ_RBN"
#define MOO_TARGET_TABLE_MEDSNRH_RBN  "MEDIAN_SNR_H_RBN"

#define MOO_TARGET_TABLE_PMEDSNRRI_EXT "PMEDIAN_SNR_RI_EXT"
#define MOO_TARGET_TABLE_PMEDSNRYJ_EXT "PMEDIAN_SNR_YJ_EXT"
#define MOO_TARGET_TABLE_PMEDSNRH_EXT  "PMEDIAN_SNR_H_EXT"

#define MOO_TARGET_TABLE_PDERSNRRI_EXT "PDERSNR_RI_EXT"
#define MOO_TARGET_TABLE_PDERSNRYJ_EXT "PDERSNR_YJ_EXT"
#define MOO_TARGET_TABLE_PDERSNRH_EXT  "PDERSNR_H_EXT"

#define MOO_TARGET_TABLE_PMEDSNRRI_RBN "PMEDIAN_SNR_RI_RBN"
#define MOO_TARGET_TABLE_PMEDSNRYJ_RBN "PMEDIAN_SNR_YJ_RBN"
#define MOO_TARGET_TABLE_PMEDSNRH_RBN  "PMEDIAN_SNR_H_RBN"

#define MOO_TARGET_TABLE_MEDSNRRI_SCI "MEDIAN_SNR_RI_SCI"
#define MOO_TARGET_TABLE_MEDSNRYJ_SCI "MEDIAN_SNR_YJ_SCI"
#define MOO_TARGET_TABLE_MEDSNRH_SCI  "MEDIAN_SNR_H_SCI"

#define MOO_TARGET_TABLE_EXTNAME "TARGET_TABLE"
/**
 * @ingroup moo_target_table
 *
 * @brief the different type of detectors
 */


typedef struct
{
    const char *filename;
    cpl_propertylist *primary_header;
    cpl_table *table;
} moo_target_table;

enum _moo_target_table_mode_
{
    /* type */

    /**
     * Stare mode
     */
    MOO_MODE_STARE,
    /**
     * StareNod mode
     */
    MOO_MODE_STARENOD,
    /**
     * H detector type
     */
    MOO_MODE_XSWITCH
};

/**
 * @ingroup moo_target_table
 *
 * @brief
 *   The type code type.
 */


typedef enum _moo_target_table_mode_ moo_target_table_mode;

const char *moo_target_table_mode_get_name(moo_target_table_mode m);
moo_target_table *moo_target_table_new(void);
moo_target_table *moo_create_empty_target_table(void);
moo_target_table *moo_create_target_table(moo_rbn *rbnA,
                                          moo_rbn *rbnB,
                                          moo_target_table_mode mode,
                                          moo_target_table_params *params);
moo_target_table *moo_target_table_duplicate(moo_target_table *self);

cpl_array *
moo_target_table_select_sky_index(moo_target_table *self, moo_rbn *sky_rbn);
cpl_error_code moo_target_table_select_stare(moo_target_table *self);
cpl_error_code moo_target_table_select_pstare(moo_target_table *self);
cpl_error_code moo_target_table_select_nod(moo_target_table *self);
cpl_error_code moo_target_table_select_pnod(moo_target_table *self);
cpl_array *
moo_target_table_select_obj_index(moo_target_table *self, int ispaired);
cpl_array *moo_target_table_select_obj_index_qlook(moo_target_table *self);
cpl_error_code
moo_target_table_save(moo_target_table *self, const char *filename);

moo_target_table *moo_target_table_load(const cpl_frame *frame);
void moo_target_table_delete(moo_target_table *self);
cpl_error_code
moo_target_table_merge(moo_target_table *self, moo_target_table *tomerge);
int moo_target_table_find_target(moo_target_table *self, const char *targname);
int moo_target_table_find_index(moo_target_table *self, const char *targname);
const char *moo_target_table_get_std_name(moo_target_table *self);
cpl_error_code moo_target_table_set_exptimes(moo_target_table *self,
                                             double *exptimeA,
                                             double *exptimeB);
cpl_error_code moo_target_table_set_exptime(moo_target_table *self,
                                            int i,
                                            int j,
                                            double exptime);
double moo_target_table_get_exptime(moo_target_table *self, int i, int j);
cpl_error_code moo_target_table_remove_coadd_cols(moo_target_table *self);
cpl_error_code moo_target_table_set_snr(moo_target_table *self,
                                        int idx,
                                        cpl_table *ft,
                                        int ft_idx);
cpl_error_code moo_target_table_set_ft_psnr(moo_target_table *self,
                                            int idx,
                                            cpl_table *ft,
                                            int ft_idx);
cpl_error_code moo_target_table_set_psnr(moo_target_table *self,
                                         int idx,
                                         moo_target_table *tcopy,
                                         int ft_idx);
cpl_error_code moo_target_table_copy_row(moo_target_table *self,
                                         int idx,
                                         moo_target_table *tocopy,
                                         int ft_idx);
int moo_is_obstype_stare(const char *obstype);
int moo_target_table_xswitch_paired(moo_target_table *self);
#endif
