/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_WAVESOL_H
#define MOO_WAVESOL_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include <hdrl.h>
#include "moo_params.h"
#include "moo_det.h"
#include "moo_ext.h"
#include "moo_spectral_format.h"
#include "moo_loc.h"
#include "moo_map.h"
/*-----------------------------------------------------------------------------
                                   Types
 -----------------------------------------------------------------------------*/

#define MOO_DEBUG_WAVESOL_DETECTED 0
#define MOO_DEBUG_WAVESOL_MATCHING 0
#define MOO_DEBUG_WAVESOL_FIT2D    0

#define MOO_ARCLINE_LIST_WAVE           "WAVE"
#define MOO_ARCLINE_LIST_BAND           "BAND"
#define MOO_ARCLINE_LIST_USEGUESS       "USEGUESS"
#define MOO_ARCLINE_LIST_USEGUESS_REFIT "USEGUESS_REFIT"
#define MOO_ARCLINE_LIST_USEFINAL       "USEFINAL"

#define MOO_WAVESOL_REFTABLE_WAVE "WAVE"
#define MOO_WAVESOL_REFTABLE_X    "X"
/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
moo_map *moo_wavesol(moo_ext *arc_ext,
                     const char *lineCatname,
                     moo_spectral_format *specFormat,
                     moo_loc *loc,
                     moo_map *wmap,
                     moo_wavesol_params *params);

#endif
