/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>
#include <hdrl.h>
#include "moo_single.h"
#include "moo_det.h"
#include "moo_detlist.h"
#include <moo_drl.h>
#include <moo_dfs.h>
#include "moo_testbed_utils.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup moons_prepare_test  Unit test of moons_prepare
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/


/*----------------------------------------------------------------------------*/
/**
  @brief    Unit test of moons_dfs_set_groups
 */
/*----------------------------------------------------------------------------*/

char *
path_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", DATA_DIR, name);
}

char *
result_from_filename(const char *name)
{
    return cpl_sprintf("%s/%s", RESULT_DIR, name);
}

static void
_moons_test_correct_dark(void)
{
    char *filename = path_from_filename("FLAT_CORRECTBIAS_OFFSET1_HR_0.fits");
    char *filename_off =
        path_from_filename("FLATOFF_PREPARE_OFFSET1_HR_0.fits");
    char *mdarkvis_name = path_from_filename("MASTER_DARK_VIS.fits");

    cpl_frame *frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_frame_set_tag(frame, "TAG");
    cpl_frame_set_group(frame, CPL_FRAME_GROUP_RAW);

    cpl_frame *frameoff = cpl_frame_new();
    cpl_frame_set_filename(frameoff, filename_off);
    cpl_frame_set_tag(frameoff, "TAG");
    cpl_frame_set_group(frameoff, CPL_FRAME_GROUP_RAW);

    cpl_frame *mdarkvis_frame = cpl_frame_new();
    cpl_frame_set_filename(mdarkvis_frame, mdarkvis_name);
    cpl_frame_set_tag(mdarkvis_frame, MOONS_TAG_MASTER_DARK_VIS);
    cpl_frame_set_group(mdarkvis_frame, CPL_FRAME_GROUP_CALIB);

    moo_det *res = moo_det_create(frame);
    moo_det *detoff = moo_det_create(frameoff);
    moo_correct_dark(res, detoff, mdarkvis_frame, NULL);

    char *resname = result_from_filename("FLAT_CORRECTDARK_OFFSET1_HR.fits");
    moo_det_save(res, resname);
    cpl_free(resname);
    moo_det_delete(res);
    moo_det_delete(detoff);

    cpl_free(filename);
    cpl_free(filename_off);
    cpl_free(mdarkvis_name);

    cpl_frame_delete(frame);
    cpl_frame_delete(frameoff);
    cpl_frame_delete(mdarkvis_frame);
    return;
}


/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of moons_dfs module
 */
/*----------------------------------------------------------------------------*/

int
main()
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    _moons_test_correct_dark();
    return cpl_test_end(0);
}

/**@}*/
