/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/

#include "moo_qc.h"
#include "moo_det.h"
#include "moo_detector.h"
#include "moo_testbed_utils.h"
#include <moo_drl.h>

#include <cpl.h>
#include <stdlib.h>
#include <stdio.h>
#include <fitsio2.h>
#include <string.h>
/*----------------------------------------------------------------------------*/
/**
 * @defgroup detector_test
        Testing of functions working on detector
 */
/*----------------------------------------------------------------------------*/

static void _moo_detector_test(void)
{
    const char* extname = moo_detector_get_extname(MOO_TYPE_RI,-1);
    int status = strcmp(extname,MOO_CHANNEL_RI_NAME); 
    cpl_test_eq(status,0);    
    
    extname = moo_detector_get_extname(MOO_TYPE_RI,1);
    status = strcmp(extname,MOO_DETECTOR_RI1_NAME); 
    cpl_test_eq(status,0);    
    
    extname = moo_detector_get_extname(MOO_TYPE_RI,10);    
    cpl_test_error(CPL_ERROR_ILLEGAL_INPUT);   
    
    extname = moo_detector_get_qual_extname(MOO_TYPE_RI, 1);    
    status = strcmp(extname,MOO_EXTNAME(MOO_QUAL,MOO_DETECTOR_RI1_NAME)); 
    cpl_test_eq(status,0);    
}


/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests of hdrl_image module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    //_moo_detector_test();
    cpl_errorstate prev_state1 = cpl_errorstate_get();
    
    cpl_error_set(__func__,CPL_ERROR_NULL_INPUT);
    
    cpl_errorstate prev_state2 = cpl_errorstate_get();
    cpl_msg_info("test","state2 begin error code %d",cpl_error_get_code());
    cpl_error_set(__func__,CPL_ERROR_NULL_INPUT);
    cpl_errorstate_dump(prev_state2, CPL_FALSE,
                            cpl_errorstate_dump_one);
    if (!cpl_errorstate_is_equal(prev_state2)){
                cpl_msg_info("test","not equal %d",cpl_error_get_code());
		cpl_errorstate_set(prev_state2);
	}
    cpl_msg_info("test","%d",cpl_error_get_code());
    cpl_errorstate_set(prev_state2);
    cpl_msg_info("test","return at state2 %d",cpl_error_get_code());
    cpl_errorstate_dump(prev_state1, CPL_FALSE,
                            cpl_errorstate_dump_one);
    cpl_error_reset();
    cpl_msg_info(__func__,"new status");
    
    cpl_error_set(__func__,CPL_ERROR_ILLEGAL_INPUT);
    cpl_msg_info("test","%d",cpl_error_get_code());
    cpl_errorstate prev_state3 = cpl_errorstate_get();
    
    cpl_propertylist* list = cpl_propertylist_new();
    int status = moo_qc_set_ncrh(list, 10);
    cpl_propertylist_dump(list,stdout);
    cpl_propertylist_delete(list);
    cpl_errorstate_dump(prev_state3, CPL_FALSE,
                            cpl_errorstate_dump_one);
    
    cpl_msg_info("test","%d %d",status,cpl_error_get_code());
    
    cpl_error_reset();
    return cpl_test_end(0);
}
