/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/

#include "moo_qc.h"
#include "moo_testbed_utils.h"
#include <moo_drl.h>

#include <cpl.h>
#include <stdlib.h>
#include <stdio.h>
#include <fitsio2.h>
#include <string.h>
/*----------------------------------------------------------------------------*/
/**
 * @defgroup error WF test
     Testing the error hanndling like cpl
 *   when a cpl function return an error code, it changes the cpl_error_get_code()
 *   when no error occured the cpl_error_get_code is not modified and a 
 *   CPL_ERROR_NONE is returned.
 *   in moons we try to implement same design for simple error handling
 */
/*----------------------------------------------------------------------------*/

static void _moo_errcode_cplwf_test(void)
{   
    /* init error code */
    cpl_error_code initcode = CPL_ERROR_ILLEGAL_INPUT;
    cpl_error_set(__func__,initcode);        
    /* call function with no error */
    cpl_propertylist* list = cpl_propertylist_new();
    int status = moo_qc_set_ncrh(list, 10);    
    cpl_propertylist_delete(list);
    cpl_test_eq(status,CPL_ERROR_NONE);
    cpl_test_eq(cpl_error_get_code(),initcode);
        
    status = moo_qc_set_ncrh(NULL, 10);    
    cpl_test_eq(status,CPL_ERROR_NULL_INPUT);
    cpl_test_eq(cpl_error_get_code(),CPL_ERROR_NULL_INPUT);
    
    cpl_error_reset();    
}

static void _moo_errcode_cplwf_test2(void)
{   
    /* init error code */
    cpl_error_code initcode = CPL_ERROR_ILLEGAL_INPUT;
    cpl_error_set(__func__,initcode);        
    /* call function with no error */
    cpl_propertylist* list = cpl_propertylist_new();
    int status = moo_qc_set_mbias_avg(list, 1, 10.5); 
    
    cpl_test_eq(status,CPL_ERROR_NONE);
    cpl_test_eq(cpl_error_get_code(),initcode);
    cpl_propertylist_delete(list);    
    status = moo_qc_set_mbias_avg(NULL, 1, 10.5); 
    
    cpl_test_eq(status,CPL_ERROR_NULL_INPUT);
    cpl_test_eq(cpl_error_get_code(),CPL_ERROR_NULL_INPUT);
    
    cpl_error_reset();    
}

static void _moo_errcode_cplwf_test3(void)
{   
    cpl_errorstate prev1 = cpl_errorstate_get();
    /* init error code */
    cpl_error_code initcode = CPL_ERROR_ILLEGAL_INPUT;
    cpl_error_set(__func__,initcode);        
    /* call function with no error */
    cpl_errorstate prev2 = cpl_errorstate_get();
    cpl_error_set(__func__,CPL_ERROR_NULL_INPUT);            
    cpl_errorstate_set(prev2);
    cpl_errorstate_dump(prev1, CPL_FALSE, cpl_errorstate_dump_one);    
    
    cpl_error_reset();    
}

/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests for error handling
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

    //_moo_errcode_cplwf_test();
    _moo_errcode_cplwf_test3();
    return cpl_test_end(0);
}
