/*
 * This file is part of the HDRL
 * Copyright (C) 2013,2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                    Includes
 -----------------------------------------------------------------------------*/


#include "moo_det.h"
#include "moo_products.h"
#include <cpl.h>

#include <stdlib.h>
#include <stdio.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup hdrl_imagelist_io-test 
        Testing of functions working on hdrl_imagelist
 */
/*----------------------------------------------------------------------------*/

static void _moo_products_test(void)
{
    moo_products *products = NULL;    
    
    products = moo_products_new(NULL,NULL,NULL,NULL);                
    cpl_test_error(CPL_ERROR_NULL_INPUT);    
    
    cpl_frameset* framelist = cpl_frameset_new();
    cpl_parameterlist* parlist = cpl_parameterlist_new();
    const char *recid = "recid";
    const char* pid = "pid";
    moo_params* params = moo_params_new("moons",recid);
    moo_params_add_keep_temp(params, parlist);
    
    products = moo_products_new(framelist,parlist,recid,pid);                
    cpl_test_error(CPL_ERROR_NONE);
    
    moo_det* det = moo_det_new();
    det->primary_header = cpl_propertylist_new();
    moo_products_add(products, det, CPL_FRAME_LEVEL_FINAL,"test","test.fits",
            NULL); 
    cpl_test_error(CPL_ERROR_DATA_NOT_FOUND);
    
    moo_det_delete(det);
    moo_products_delete(products);
    
    moo_params_delete(params);
    cpl_frameset_delete(framelist);
    cpl_parameterlist_delete(parlist);
}


/*----------------------------------------------------------------------------*/
/**
 @brief   Unit tests of hdrl_image module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    _moo_products_test();

    return cpl_test_end(0);
}
