/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>

#include <cpl.h>
#include <hdrl.h>
#include <moo_drl.h>
#include <moo_dfs.h>
#include "moo_region.h"
#include "moo_testbed_utils.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup moons_region_test  Unit test of moons_region
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/
static void _moo_region_test(void)
{
    moo_region* reg = moo_region_load("a:12:12:1");
    cpl_test_null(reg);    
    
    reg = moo_region_load("1,2,3,4");
    cpl_test_nonnull(reg);    
    
    cpl_test_eq(reg->xb,1);
    cpl_test_eq(reg->yb,2);
    cpl_test_eq(reg->xu,3);
    cpl_test_eq(reg->yu,4);
    
    moo_region_delete(reg);
}

static void _moo_regionlist_test(void)
{
    moo_regionlist* reglist = moo_regionlist_new(10);
    cpl_test_nonnull(reglist);        
    moo_regionlist_delete(reglist);
    
    reglist = moo_regionlist_load("1,1,2,2:3,3,4,4:5,5,6,6");
    cpl_test_eq(reglist->list[0]->xb,1);
    cpl_test_eq(reglist->list[2]->yu,6);
    moo_regionlist_delete(reglist);
}
/*----------------------------------------------------------------------------*/
/**
  @brief    Unit tests of moons_region module
 */
/*----------------------------------------------------------------------------*/

int
main()
{
    
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_INFO);

    _moo_region_test();
    _moo_regionlist_test();

    return cpl_test_end(0);
}

/**@}*/
