/*
 * This file is part of the MOONS Pipeline
 * Copyright (C) 2002-2016 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MOO_TESTS_H
#define MOO_TESTS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#define MOO_TESTS_DOUBLE_PRECISION 0.0000001

void moo_testbed_create_raw(int npix, const char* bands[], int nbbands,
        int ntas, const char* output, double gain, double ron, 
        double exptime, double offset, double val);

void moo_testbed_create_bpmap(int npix, const char* bands[], int nbband, int ntas, 
        const char* output,int (*badpix)[][2], int nbbadpix);

cpl_frameset* moo_testbed_frameset_load(const char* sof);

#endif
