/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */


/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/


#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <cpl_type.h>
#include <cpl_memory.h>
#include <cpl_msg.h>


/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/
enum MF_WRAP_STRLST_TYPE
{
    MF_WRAP_STRLST_NULL,
    MF_WRAP_STRLST_STRING,
    MF_WRAP_STRLST_DOUBLE,
    MF_WRAP_STRLST_MF_DRANGE,
    MF_WRAP_STRLST_INT,
    MF_WRAP_STRLST_BOOL
};

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_boolean mf_strlst_is_null(const char *strlst);
int         mf_strlst_get_size(const char *strlst);
char       *mf_wrap_strlst_get_str(const char *strlst, int idx);
double      mf_strlst_get_double(const char *strlst, int idx);
float       mf_strlst_get_float(const char *strlst, int idx);
int         mf_strlst_get_int(const char *strlst, int idx);
cpl_boolean mf_strlst_get_boolean(const char *strlst, int idx);
cpl_boolean mf_wrap_strlst_is_valid(const char *strlst, enum MF_WRAP_STRLST_TYPE strlst_type);
cpl_boolean mf_wrap_strlst_is_valid_list_of_types(const char *strlst, cpl_type data_type);
cpl_boolean mf_strlst_get_bool_err(const char *strlst, int idx, char *ret_str);
char      **mf_str_split(const char *str, const char *delimiter, cpl_size *size);
void        mf_str_array_delete(char **strarr);
