/*
 * This file is part of the Molecfit Pipeline
 * Copyright (C) 2001-2019 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_DFS_H_
#define MF_WRAP_DFS_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <string.h>
#include <math.h>

#include <cpl.h>
#include "mf_constants.h"

//#include <telluriccorr.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

/* Raws */
#define MOLECFIT_STD_MODEL         "STD_MODEL"
#define MOLECFIT_SCIENCE_CALCTRANS "SCIENCE_CALCTRANS"
#define MOLECFIT_SCIENCE           "SCIENCE"


/* Calibration */
#define MOLECFIT_MOLECULES MF_INPUT_MOLECULES

#define MOLECFIT_WAVE_INCLUDE  MF_INPUT_WAVE_INCLUDE
#define MOLECFIT_WAVE_EXCLUDE  MF_INPUT_WAVE_EXCLUDE
#define MOLECFIT_PIXEL_EXCLUDE MF_INPUT_PIXEL_EXCLUDE

#define MOLECFIT_GDAS MF_INPUT_GDAS

#define MOLECFIT_ATM_PROFILE_STANDARD MF_INPUT_ATM_PROFILE_STANDARD

#define MOLECFIT_KERNEL_LIBRARY "KERNEL_LIBRARY"
#define MOLECFIT_MAPPING_KERNEL "MAPPING_KERNEL"

#define MOLECFIT_MODEL_KERNEL_LIBRARY "MODEL_KERNEL_LIBRARY"
#define MOLECFIT_MODEL_MAPPING_KERNEL "MODEL_MAPPING_KERNEL"

#define MOLECFIT_CALCTRANS_KERNEL_LIBRARY "CALCTRANS_KERNEL_LIBRARY"
#define MOLECFIT_CALCTRANS_MAPPING_KERNEL "CALCTRANS_MAPPING_KERNEL"

#define MOLECFIT_MAPPING_ATMOSPHERIC "MAPPING_ATMOSPHERIC"
#define MOLECFIT_MAPPING_CONVOLVE    "MAPPING_CONVOLVE"
#define MOLECFIT_MAPPING_CORRECT     "MAPPING_CORRECT"
#define MOLECFIT_FIT_MODEL           MOLECFIT_TELLURIC_DATA

/* Expert Mode Initial Fit Values*/
#define MOLECFIT_MODEL_INIT_FIT_PARAMETERS "INIT_FIT_PARAMETERS"


/* Products */
#define MOLECFIT_MODEL_CHIPS_COMBINED     "MODEL_CHIPS_COMBINED"
#define MOLECFIT_CALCTRANS_CHIPS_COMBINED "CALCTRANS_CHIPS_COMBINED"
#define MOLECFIT_CORRECT_CHIPS_COMBINED   "CORRECT_CHIPS_COMBINED"

#define MOLECFIT_GDAS_BEFORE "GDAS_BEFORE"
#define MOLECFIT_GDAS_AFTER  "GDAS_AFTER"

#define MOLECFIT_ATM_PROFILE_COMBINED MF_INPUT_ATM_PROFILE_COMBINED

#define MOLECFIT_MODEL_MOLECULES "MODEL_" MOLECFIT_MOLECULES

#define MOLECFIT_ATM_PARAMETERS      "ATM_PARAMETERS"
#define MOLECFIT_BEST_FIT_PARAMETERS "BEST_FIT_PARAMETERS"
#define MOLECFIT_BEST_FIT_MODEL      "BEST_FIT_MODEL"
#define MOLECFIT_MOLECULE_ABUNDANCES "MOLECULE_ABUNDANCES"

#define MOLECFIT_LBLRTM_RESULTS "LBLRTM_RESULTS"

#define MOLECFIT_TELLURIC_DATA "TELLURIC_DATA"
#define MOLECFIT_TELLURIC_CORR "TELLURIC_CORR"

#define MOLECFIT_SCIENCE_TELLURIC_CORR  "SCIENCE_TELLURIC_CORR"
#define MOLECFIT_SPECTRUM_TELLURIC_CORR "SPECTRUM_TELLURIC_CORR"


/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/

/* */
cpl_error_code mf_wrap_dfs_set_groups(cpl_frameset *set);

/* */
cpl_error_code mf_wrap_dfs_save_vector(
    cpl_frameset            *allframes,
    cpl_propertylist        *header,
    const cpl_parameterlist *parlist,
    const cpl_frameset      *usedframes,
    const cpl_frame         *inherit,
    const cpl_vector        *vector,
    cpl_type                 type,
    const char              *recipe,
    const cpl_propertylist  *applist,
    const char              *remregexp,
    const char              *pipe_id,
    const char              *filename
);


CPL_END_DECLS


#endif /* MF_WRAP_DFS_H_ */
