/*                                                                           a
 *   This file is part of the ESO X-shooter Pipeline                         *
 *   Copyright (C) 2006 European Southern Observatory                        *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-06 14:49:56 $
 * $Revision: 1.5 $
 * $Name: not supported by cvs2svn $
 */
#ifndef ESPDR_CCD_H
#define ESPDR_CCD_H

/*----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include <string.h>
#include <cpl.h>

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

/* Structure holding the CCD output geometry parameters */
typedef struct {
    int out_no;
    int out_phys_no;
    int ext_no;
    int out_x;
    int out_y;
    int raw_nx;
    int raw_ny;
    int real_nx;
    int real_ny;
    int real_llx;
    int real_lly;
    int real_urx;
    int real_ury;
    int pscan_nx;
    int pscan_ny;
    int pscan_llx;
    int pscan_lly;
    int pscan_urx;
    int pscan_ury;
    int oscan_nx;
    int oscan_ny;
    int oscan_llx;
    int oscan_lly;
    int oscan_urx;
    int oscan_ury;
    int ppscan_nx;
    int ppscan_ny;
    int ppscan_llx;
    int ppscan_lly;
    int ppscan_urx;
    int ppscan_ury;
    int poscan_nx;
    int poscan_ny;
    int poscan_llx;
    int poscan_lly;
    int poscan_urx;
    int poscan_ury;
} espdr_CCD_output;

/* Structure holding the CCD extension geometry parameters */
typedef struct {
    int ext_nb;
    int ext_no;
    int out_nb_x;
    int out_nb_y;
    int coll_or;
    int corr_type;
    int rot_angle;
    int ver_flip;
    int hor_flip;
    double pxl_size;
    int CCD_nx;
    int CCD_ny;
    int image_nx;
    int image_ny;
    espdr_CCD_output **outputs;
} espdr_CCD_extension;

/* Structure holding the whole CCD geometry parameters*/
typedef struct {
    char instrument[50];
    espdr_CCD_extension *exts;
    int ext_nb;
    int total_output_nb;
} espdr_CCD_geometry;


/* Columns definition for CCD extensions */
// Instrument name: HARPS, HARPN, ESPRESSO
static const char COL_NAME_INST_NAME[] = "INST_NAME";
// Number of extensions per image
static const char COL_NAME_EXT_NB[] = "EXT_NB";
// Number of extension within the image: first, second, ...
static const char COL_NAME_EXT_NO[] = "EXT_NO";
// Numebr of outputs in X direction
static const char COL_NAME_OUT_NB_X[] = "OUT_NB_X";
// Number of outputs in Y direction
static const char COL_NAME_OUT_NB_Y[] = "OUT_NB_Y";
// Orientation of the CCD collumns
static const char COL_NAME_COLL_OR[] = "COLLUMN_ORIENTATION";
// ???
static const char COL_NAME_CORR_TYPE[] = "CORRECTION_TYPE";
// Angle to rotate the CCD to have the lines horizontally
static const char COL_NAME_ROT_ANGLE[] = "ROTATION_ANGLE";
// Is the CCD flip vertically?
static const char COL_NAME_VER_FLIP[] = "VERTICAL_FLIP";
// Is the CCD flip horizontally?
static const char COL_NAME_HOR_FLIP[] = "HORIZONTAL_FLIP";
// Pixel size in microns
static const char COL_NAME_PXL_SIZE[] = "PIXEL_SIZE_MICRON";
/* These last 4 are only for a check
 CCD_NX, CCD_NY: real size of the CCD
 IMAGE_NX, IMAGE_NY: size of the image in the raw file
 */
static const char COL_NAME_CCD_NX[] = "CCD_NX";
static const char COL_NAME_CCD_NY[] = "CCD_NY";
static const char COL_NAME_IMAGE_NX[] = "IMAGE_NX";
static const char COL_NAME_IMAGE_NY[] = "IMAGE_NY";

/* Column definition for CCD outputs */
// instrument name: "INST_NAME"
// extension number: "EXT_NO"
// Number of output within the extension
static const char COL_NAME_OUT_NO[] = "OUT_NO";
// Physical number of output within the extension
static const char COL_NAME_OUT_PHYS_NO[] = "OUT_PHYS_NO";
// X coordinate of the output
static const char COL_NAME_OUT_X[] = "OUT_X";
// Y coordinate of the output
static const char COL_NAME_OUT_Y[] = "OUT_Y";
// Raw image size
static const char COL_NAME_RAW_NX[] = "RAW_NX";
static const char COL_NAME_RAW_NY[] = "RAW_NY";
// Size of the real part of the image
static const char COL_NAME_REAL_NX[] = "REAL_NX";
static const char COL_NAME_REAL_NY[] = "REAL_NY";
// Coordinates of the lower left corner and the upper right corner
// of the part of the real image, that is used in the recipes
static const char COL_NAME_REAL_LLX[] = "REAL_LLX";
static const char COL_NAME_REAL_LLY[] = "REAL_LLY";
static const char COL_NAME_REAL_URX[] = "REAL_URX";
static const char COL_NAME_REAL_URY[] = "REAL_URY";
// Prescan size
static const char COL_NAME_PSCAN_NX[] = "PRESCAN_NX";
static const char COL_NAME_PSCAN_NY[] = "PRESCAN_NY";
// Coordinates of the sub-prescan rectangle which is used in the recipes
static const char COL_NAME_PSCAN_LLX[] = "PRESCAN_LLX";
static const char COL_NAME_PSCAN_LLY[] = "PRESCAN_LLY";
static const char COL_NAME_PSCAN_URX[] = "PRESCAN_URX";
static const char COL_NAME_PSCAN_URY[] = "PRESCAN_URY";
// Overscan size
static const char COL_NAME_OSCAN_NX[] = "OVERSCAN_NX";
static const char COL_NAME_OSCAN_NY[] = "OVERSCAN_NY";
// Coordinates of the sub-overscan rectangle which is used in the recipes
static const char COL_NAME_OSCAN_LLX[] = "OVERSCAN_LLX";
static const char COL_NAME_OSCAN_LLY[] = "OVERSCAN_LLY";
static const char COL_NAME_OSCAN_URX[] = "OVERSCAN_URX";
static const char COL_NAME_OSCAN_URY[] = "OVERSCAN_URY";
// Perpendicular prescan size
static const char COL_NAME_PPSCAN_NX[] = "PPRESCAN_NX";
static const char COL_NAME_PPSCAN_NY[] = "PPRESCAN_NY";
// Used part of the perpendicular prescan
static const char COL_NAME_PPSCAN_LLX[] = "PPRESCAN_LLX";
static const char COL_NAME_PPSCAN_LLY[] = "PPRESCAN_LLY";
static const char COL_NAME_PPSCAN_URX[] = "PPRESCAN_URX";
static const char COL_NAME_PPSCAN_URY[] = "PPRESCAN_URY";
// Perpendicular overscan size
static const char COL_NAME_POSCAN_NX[] = "POVERSCAN_NX";
static const char COL_NAME_POSCAN_NY[] = "POVERSCAN_NY";
// Used part of the perpendicular overscan
static const char COL_NAME_POSCAN_LLX[] = "POVERSCAN_LLX";
static const char COL_NAME_POSCAN_LLY[] = "POVERSCAN_LLY";
static const char COL_NAME_POSCAN_URX[] = "POVERSCAN_URX";
static const char COL_NAME_POSCAN_URY[] = "POVERSCAN_URY";



/*----------------------------------------------------------------------------
 Prototypes
 ----------------------------------------------------------------------------*/

espdr_CCD_geometry* espdr_CCD_geom_init(cpl_parameterlist *parameters,
                                        cpl_frame* CCD_geom_frame);

cpl_error_code espdr_read_CCD_parameters(const char *filename,
                                         espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_parameters_CCD_geometry_print(espdr_CCD_geometry *CCD_geom);

cpl_error_code espdr_parameters_CCD_geometry_delete(espdr_CCD_geometry *CCD_geom);

#endif
