/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2014-10-28 15:13:41 $
 * $Revision:     $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_BLAZE_H
#define ESPDR_BLAZE_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_keywords.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_pixels.h>

/* Library */
#include <cpl.h>
#include <assert.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_measure_blaze(cpl_image *spectrum_order,
                                   double *weight,
                                   int size_slidinbox,
                                   cpl_image **blaze_order_RE);

cpl_error_code espdr_blaze_and_flat_calculation(cpl_image *extracted_e2ds,
                                                const char *blaze_computation_method,
                                                int blaze_pol_deg,
                                                int size_sliding_box,
                                                double blaze_clip,
                                                cpl_image *spectrum_error_table,
                                                cpl_image **flat_RE,
                                                cpl_image **blaze_RE);

cpl_error_code espdr_correct_s2d_instrumental(cpl_image *flux,
                                              cpl_image *error,
                                              cpl_image *wave,
                                              cpl_image *dll,
                                              int avgblaze_window_calc,
                                              int deg,
                                              int *physical_orders_id,
                                              char *blaze_peaks_fit_method,
                                              cpl_image **flux_RE,
                                              cpl_image **error_RE);

cpl_error_code espdr_blaze_and_flat_fit_order(cpl_image *extracted_e2ds,
                                              int blaze_pol_deg,
                                              cpl_image *spectrum_error_table,
                                              cpl_image **flat_RE,
                                              cpl_image **blaze_RE);

cpl_error_code espdr_correct_blaze(cpl_image *extracted_spectrum_table,
                                   cpl_image *spectrum_error_table,
                                   cpl_image *spectrum_quality_table,
                                   cpl_image *blaze,
                                   cpl_image **extracted_spectrum_table_corrected_RE,
                                   cpl_image **spectrum_error_table_corrected_RE,
                                   cpl_image **spectrum_quality_table_RE);

cpl_error_code espdr_correct_flat(cpl_image *extracted_spectrum_table,
                                  cpl_image *spectrum_error_table,
                                  cpl_image *spectrum_quality_table,
                                  cpl_image *flat_spectrum_table,
                                  cpl_image *flat_spectrum_error_table,
                                  cpl_image *flat_spectrum_quality,
                                  cpl_image **extracted_spectrum_table_corrected_RE,
                                  cpl_image **spectrum_error_table_corrected_RE,
                                  cpl_image **spectrum_quality_table_RE);

cpl_error_code espdr_s2d_normalisation(cpl_image *flux,
                                       cpl_image *error,
                                       int window,
                                       int *physical_orders_id,
                                       cpl_image **flux_RE,
                                       cpl_image **error_RE);

#endif /* ESPDR_BLAZE_H */
