/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: asegovia $
 * $Date: 2015-11-10 14:48:13 $
 * $Revision: 1.16 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_DRIFT_H
#define ESPDR_DRIFT_H

/*---------------------------------------------------------------------------*/
/**
 * drift
 *
 * drift functions header
 */


/*----------------------------------------------------------------------------
                                Includes
 ----------------------------------------------------------------------------*/

/* Utility fonctions */
#include <math.h>

/* DRL functions*/
#include <espdr_dfs.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_pixels.h>
#include <espdr_orders.h>

/* Library */
#include <cpl.h>
#include <assert.h>
#include <stdio.h>
#include <gsl/gsl_multifit.h>

/*----------------------------------------------------------------------------
								Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

// TO BE REMOVED ...
#define DRIFT_WINDOW_SIZE_MIN 1.
#define DRIFT_WINDOW_SIZE_MAX 240.
#define DRIFT_KSIG_MIN -1.
#define DRIFT_KSIG_MAX 1.



/* These ones should be editable from drift.rc */
//#define DRIFT_MAX_FLUX_THRESHOLD 350000.
//#define DRIFT_MIN_FLUX_THRESHOLD 100.
#define GOOD_PIXEL 0

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/
int espdr_compu_drift(cpl_parameterlist *parameters, cpl_frameset *frameset,
		const char* recipe_id);

cpl_error_code espdr_drift_table_init(cpl_table *drift_table,
                                      espdr_CCD_geometry *CCD_geom,
                                      espdr_inst_config *inst_config,
                                      int fibre,
                                      int *first_order_second_ext);

cpl_error_code espdr_measure_drift(cpl_image *flux,
                                   cpl_image *err,
                                   cpl_image *qual,
                                   cpl_image *flux_ref,
                                   cpl_image *err_ref,
                                   cpl_image *qual_ref,
                                   cpl_image *ll,
                                   cpl_image *dll,
                                   char *drift_method,
                                   char *drift_space,
                                   double ksig,
                                   double max_flux_threshold,
                                   double min_flux_threshold,
                                   double cosmics_part,
                                   cpl_table **drift_results_RE,
                                   cpl_image **drift_matrix_RE);

cpl_error_code espdr_normalize_spectrum(cpl_image *flux,
                                        cpl_image *err,
                                        cpl_image *flux_ref,
                                        cpl_image *err_ref,
                                        cpl_image *qual_updated,
                                        cpl_image **norm_flux_RE,
                                        cpl_image **norm_err_RE,
                                        double *flux_ratio,
                                        double *flux_ratio_err);

cpl_error_code espdr_discard_pixels(cpl_image *flux,
                                    cpl_image *err,
                                    cpl_image *qual,
                                    cpl_image *flux_ref,
                                    cpl_image *err_ref,
                                    cpl_image *qual_ref,
                                    double max_flux_threshold,
                                    double min_flux_threshold,
                                    double cosmics_part,
                                    cpl_image **qual_updated_RE);

cpl_error_code espdr_compute_derivative(cpl_image *flux,
                                        cpl_image *err,
                                        cpl_image *qual,
                                        cpl_image **derivative_RE,
                                        cpl_image **derivative_err_RE,
                                        cpl_image **qual_updated_RE);

cpl_error_code espdr_convert_derivative(cpl_image **deriv,
                                        cpl_image **deriv_err,
                                        cpl_image *ll,
                                        cpl_image *dll);

cpl_error_code espdr_normalize_flux(cpl_image *flux,
                                    cpl_image *err,
                                    cpl_image *flux_ref,
                                    cpl_image **flux_norm,
                                    cpl_image **err_norm,
                                    double *flux_ratio,
                                    double *flux_ratio_err);

cpl_error_code espdr_correct_drift(cpl_image *wave_matrix,
                                   cpl_image *drift_matrix,
                                   cpl_image **wave_matrix_RE);

cpl_error_code espdr_create_drift_matrix(char *drift_space,
                                         int *nx,
                                         int *ny,
                                         int **physical_orders_id,
                                         espdr_inst_config *inst_config,
                                         espdr_CCD_geometry *CCD_geom,
                                         cpl_image **ll,
                                         cpl_image **dll,
                                         cpl_table **drift_results,
                                         cpl_image **drift_matrix_RE);

cpl_error_code espdr_check_drift_QC(cpl_table *drift_results,
                                    espdr_inst_config *inst_config,
                                    int ext_nb,
                                    int *drift_QC);

cpl_error_code espdr_full_drift_QC(cpl_table *drift_results,
                                   espdr_inst_config *inst_config,
                                   espdr_CCD_geometry *CCD_geom,
                                   espdr_qc_keywords *qc_kws,
                                   int *drift_chi2_check,
                                   int *drift_flux_ratio_check,
                                   int *drift_mean_check,
                                   int *drift_mean_err_check,
                                   cpl_propertylist *keywords_RE);

#endif /* espdr_DRIFT_H */
