/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_FIT_H
#define ESPDR_FIT_H

/* DRL functions*/
#include <espdr_instrument.h>
#include <espdr_utils.h>
#include <espdr_msg.h>
#include <espdr_parameters.h>
#include <espdr_CCD.h>
#include <espdr_dfs.h>
#include <espdr_dark.h>
#include <espdr_overscan.h>
#include <espdr_bias.h>

/* Library */
#include <cpl.h>
#include <assert.h>

/* GSL library */
//#include <stdlib.h>
//#include <stdio.h>
//#include <gsl/gsl_rng.h>
//#include <gsl/gsl_randist.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_blas.h>
#include <gsl/gsl_cblas.h>
#include <gsl/gsl_multifit_nlin.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_math.h>
#include <gsl/gsl_spline.h>
#include <gsl/gsl_min.h>
#include <gsl/gsl_multimin.h>
#include <gsl/gsl_multifit.h>


/*----------------------------------------------------------------------------
 Constants
 ----------------------------------------------------------------------------*/
#define GAUSS_NPAR 4

/*----------------------------------------------------------------------------
 Data structures
 ----------------------------------------------------------------------------*/
typedef struct
{
    double *x, *y, *err, *fit;
    int n, m;
    double delta;
} espdr_ngauss_data;

typedef struct
{
    double c, sig_c, *k, *sig_k, *x0, *sig_x0, *fwhm, *sig_fwhm;
    int n, m;
} espdr_ngauss_result;

typedef struct
{
    double *x, *y, *err;
    int n;
} espdr_poly_data;

typedef struct
{
    double *x, *y, *z, *err;
    int n, m;
} espdr_poly_2D_data;


/*----------------------------------------------------------------------------
 Functions
 ----------------------------------------------------------------------------*/
cpl_error_code espdr_fit_Ngauss_equi_dist(espdr_ngauss_data *data,
                                          int inter_slice_dist,
                                          int slice_width,
                                          double *x0_RE,
                                          double *sig_x0_RE,
                                          double *flux_RE,
                                          double *sig_flux_RE,
                                          double *fwhm_RE,
                                          double *fwhm_x0_RE,
                                          int spectrum_type,
                                          int print_flag);

cpl_error_code espdr_fit_Ngauss (espdr_ngauss_data *data,
                                 double *x0,
                                 double fwhm_init_factor,
                                 espdr_ngauss_result *res,
                                 int spectrum_type,
                                 int print_flag);

cpl_error_code espdr_fit_poly (espdr_poly_data *data,
                               int deg,
                               double *fit_RE,
                               double *coeffs_RE,
                               double *coeffs_err_RE,
                               double *chisq_RE,
                               int print_flag);

cpl_error_code espdr_fit_poly_2D(espdr_poly_2D_data *data,
                                 double *fit_RE,
                                 espdr_inst_config *inst_config,
                                 double *coeffs_RE,
                                 double *coeffs_err_RE,
                                 double *chisq_RE,
                                 int print_flag);

cpl_error_code espdr_spline_interpolation (double *x1, double *y1, int n1,
                                           double *x2, double *y2, int n2);

cpl_error_code espdr_spline_bounded_interpolation (double *x1, double *y1, int n1,
                                                   double *x2, double *y2, int n2,
                                                   double x_min, double x_max);

cpl_error_code espdr_spline_bounded_interp_exterp (double *x1, double *y1, int n1,
                                                   double *x2, double *y2, int n2);

#endif /* ESPDR_FIT_H */
