/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: amodigli $
 * $Date: 2013-08-30 15:13:41 $
 * $Revision: 1.8 $
 * $Name: not supported by cvs2svn $
 */

#ifndef ESPDR_HDRL_FUNC_H
#define ESPDR_HDRL_FUNC_H

/*---------------------------------------------------------------------------*/
/**
 * bias
 *
 * bias functions (using HDRL) header
 */

/*----------------------------------------------------------------------------
                                Includes
 ----------------------------------------------------------------------------*/
/* Utility fonctions */
#include <math.h>

/* DRL functions*/
#include <espdr_bias.h>

/* Library */
#include <cpl.h>
#include <hdrl.h>
#include <assert.h>
/*----------------------------------------------------------------------------
								Constants
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
 Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_error_code espdr_hdrl_master_port(cpl_imagelist *raw_data,
                                      double klow,
                                      double khigh,
                                      int max_iter,
                                      cpl_image **master_RE,
                                      double *RON_RE,
                                      int *totalCosmics_RE);

cpl_error_code espdr_hdrl_overscan(const cpl_image *master_bias_image,
                                   int ext_no,
                                   int out_x,
                                   int out_y,
                                   const espdr_CCD_geometry *CCD_geom,
                                   espdr_inst_config *inst_config,
                                   cpl_image **overscan_image_RE,
                                   double *RON_RE,
                                   int *total_cosmics_RE);

cpl_error_code espdr_hdrl_hot_pixels(cpl_imagelist *master_dark_list,
                                     espdr_CCD_geometry *CCD_geom,
                                     espdr_inst_config *inst_config,
                                     double *mean_RE,
                                     int *hot_pixels_RE,
                                     double *sigma_RE,
                                     cpl_imagelist **hot_pixel_mask_list_RE);
	
#endif /* ESPDR_HDRL_FUNC_H */
