/*                                                                            *
 *   This file is part of the ESPRESSO Pipeline                               *
 *   Copyright (C) 2006 European Southern Observatory                         *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

/*
 * $Author: dsosnows $
 * $Date: 2023-06-13 16:52:15 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 */

/* The content of this file was copied from the libcerf library,
   created by Steven G. Johnson (MIT) and Joachim Wuttke (Forschungszentrum Juelich)
   Copyright (C) [Steven G. Johnson](http:*math.mit.edu/~stevenj), Massachusetts Institute of Technology, 2012; [Joachim Wuttke](http:*www.fz-juelich.de/SharedDocs/Personen/JCNS/EN/Wuttke_J.html), Forschungszentrum Jülich, 2013.
 * S. G. Johnson, J. Wuttke: libcerf, numeric library for complex error functions, version [...], http://apps.jcns.fz-juelich.de/libcerf
 */

#ifndef ESPDR_VOIGT_H
#define ESPDR_VOIGT_H

/* Library */
#include <cpl.h>
#include <assert.h>


#include <stdio.h>
#include <float.h>
#include <math.h>


// from c.h
#if !defined(CMPLX) && \
    ( __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 7)) && \
    !(defined(__ICC) || defined(__INTEL_COMPILER))
#  define CMPLX(a,b) __builtin_complex((double) (a), (double) (b))
#endif

#ifdef CMPLX // C11
#  define C(a,b) CMPLX(a,b)
#  define Inf INFINITY // C99 infinity
#  ifdef NAN // GNU libc extension
#    define NaN NAN
#  else
#    define NaN (0./0.) // NaN
#  endif
#else
#  define C(a,b) ((a) + I*(b))
#  define Inf (1./0.)
#  define NaN (0./0.)
#endif


// from cerf.h
#include <complex.h>
typedef double _Complex _cerf_cmplx;

// compute w(z) = exp(-z^2) erfc(-iz), Faddeeva's scaled complex error function
_cerf_cmplx w_of_z(_cerf_cmplx z);

// compute voigt(x,...), the convolution of a Gaussian and a Lorentzian
double voigt(double x, double sigma, double gamma);

double erfcx(double x);

double im_w_of_x(double x);


#endif /* ESPDR_VOIGT_H */
