# import the needed modules
from __future__ import absolute_import
from __future__ import print_function

try:
    import reflex

    import_sucess = 'true'

# Then here is python code moved in xsh_object_interactive_common.py

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")

# import the needed modules
try:
    #  import sys
    import numpy

    try:
        from astropy.io import fits as pyfits
    except ImportError:
        import pyfits

    import espdr_discrete_slider
    import espdr_plot_common
    import espdr_parameters_common
    #  import wx
    #  import matplotlib
    import reflex
    # from xsh_plot_common import *
    from reflex import parseSofJson, RecipeParameter
    from reflex_interactive_app import PipelineInteractiveApp
    import reflex_plot_widgets
    from pipeline_product import PipelineProduct
    from pipeline_display import SpectrumDisplay, ImageDisplay, ScatterDisplay

    #  matplotlib.use('WXAgg')
    import_sucess = 'true'
    import warnings

    warnings.simplefilter('ignore', UserWarning)


    # NOTE for developers:
    # -If you want to modify the current script to cope
    #  with different parameters, this is the function to modify:
    #  setInteractiveParameters()
    # -If you want to modify the current script to read different data from
    #  the input FITS, these are the functions (class DataPlotterManager) to modify:
    #  readFitsData()    to indicate what are the FITS input to plot
    #  plotSpectrum()    to control 1D image product layout
    #  plotImage()       to control 2D image product layout
    #  setRecId()        to set rec id (used in parameter prefix)
    #  getArmId()        to get arm id FITS header info
    #
    # -If you want to modify the current script to modify the plots (using the same
    #  data),  this is the function to modify:
    #  plotProductsGraphics()          (from class DataPlotterManager)
    # -If you want to modify the text that appears in the "Help" button,
    #  this is the function to modify:
    #  setWindowHelp()
    # -If you want to modify the title of the window, modify this function:
    #  setWindowTitle()

    # This class deals with the specific details of data reading and final plotting.
    class DataPlotterManager:

        # This function will read all the columns, images and whatever is needed
        # from the products. The variables , self.plot_x, self.plot_y, etc...
        # are used later in function plotProductsGraphics().
        # Add/delete these variables as you need (only that plotProductsGraphics()
        # has to use the same names).
        # You can also create some additional variables (like statistics) after
        # reading the files.
        # If you use a control variable (self.xxx_found), you can modify
        # later on the layout of the plotting window based on the presence of
        # given input files.
        # sof contains all the set of frames
        def readFitsData(self, fitsFiles):
            # Control variable to check if the interesting files where at the input
            # print fitsFiles
            self.nima = 0
            self.binx = 1
            self.biny = 1
            self.ext_ima = 1
            self.order_id = 10
            self.x_id = 4000
            self.product_id = 'CONTAM_S2D_A'
            self.qc_id = 'MAX FLUX vs orders'
            self.labels_qc = ['MAX FLUX vs orders']
            self.labels_fib = ['fib A', 'fib B']
            self.labels_prod = list()
            self.contam_found = False
            # Read all the products
            frames = dict()
            # print(frames)
            for frame in fitsFiles:
                if frame == '':
                    continue

                header = pyfits.open(frame.name)
                # Make sure to have only products from the same recipe
                # that used this (common) script
                # print "self.rec_id=", self.rec_id
                if 'ESO PRO REC1 ID' in header[0].header:
                    rec_id = header[0].header['ESO PRO REC1 ID']
                    # print "rec_id=", rec_id
                    if rec_id == self.rec_id:
                        category = frame.category
                        frames[category] = frame
                        print("frame name:", frame.name)

            # For any arm search a list of input frames
            key = "CONTAM_S2D_A"
            if key in frames:
                hdulist = frames[key]
                self.contam_s2d_a_found = True
                hdulist = frames[key]
                self.contam_s2d_a = PipelineProduct(hdulist)
                # print("found", key)
                self.contam_found = True
                self.labels_prod.append(key)

            key = "CONTAM_S2D_B"
            if key in frames:
                hdulist = frames[key]
                self.contam_s2d_b_found = True
                hdulist = frames[key]
                self.contam_s2d_b = PipelineProduct(hdulist)
                # print("found", key)
                self.contam_found = True
                self.labels_prod.append(key)

            key = "CONTAM_FP"
            if key in frames:
                hdulist = frames[key]
                self.contam_fp_found = True
                hdulist = frames[key]
                self.contam_fp = PipelineProduct(hdulist)
                self.labels_prod.append(key)
                # print("found", key)
                key = 'ESO INS MODE'
                self.ins_mode = self.contam_fp.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                    self.x_id = 4000
                elif self.ins_mode == 'HA':
                    self.ord_max = 71
                elif self.ins_mode == 'HE':
                    self.ord_max = 71
                elif self.ins_mode == 'HARPS':
                    self.ord_max = 71
                    self.x_id = 4000
                else:
                    self.ord_max = 85
                    self.x_id = 2000

                self.contam_found = True
                self.max_flux = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key1 = 'ESO QC ORDER%#.1d MAX FLUX' % (ord)
                    self.order_nb_a.append(ord)
                    self.max_flux.append(self.contam_fp.readKeyword(key1))

                key = 'ESO QC CONTAM CHECK'
                self.qc_contam_check = self.contam_fp.readKeyword(key)

            key = "CONTAM_THAR"
            if key in frames:
                hdulist = frames[key]
                self.contam_thar_found = True
                hdulist = frames[key]
                self.contam_thar = PipelineProduct(hdulist)
                self.labels_prod.append(key)
                # print("found", key)
                key = 'ESO INS MODE'
                self.ins_mode = self.contam_thar.readKeyword(key)
                # print(self.ins_mode)
                if self.ins_mode == 'SINGLEHR':
                    self.ord_max = 170
                    self.x_id = 4000
                elif self.ins_mode == 'HARPS':
                    self.ord_max = 71
                    self.x_id = 4000

                else:
                    self.ord_max = 85
                    self.x_id = 2000

                self.contam_found = True
                self.max_flux = list()
                self.order_nb_a = list()
                port = 0
                for ord in range(1, self.ord_max):
                    key1 = 'ESO QC ORDER%#.1d MAX FLUX' % (ord)
                    self.order_nb_a.append(ord)
                    self.max_flux.append(self.contam_thar.readKeyword(key1))

                key = 'ESO QC CONTAM CHECK'
                self.qc_contam_check = self.contam_thar.readKeyword(key)

                # Set rec id (to have proper recipe parameters prefix)

        def setRecId(self, rec_id):
            # Recipe ID variable to properly define params
            self.rec_id = rec_id

        # Get arm setting
        def getArmId(self, sof):
            # Recipe ID variable to properly define params
            self.rec_id = "espdr_cal_contam"
            self.instrume = 'Undefined'
            nf = 0

            frames = dict()
            files = sof.files
            for f in files:
                frame = f.name
                if frame == '':
                    continue
                else:
                    nf += 1
                    hdulist = pyfits.open(frame)
                    rec_id_list = hdulist[0].header['ESO PRO REC1 ID']
                    self.instrume = hdulist[0].header['INSTRUME']
            if nf != 0:
                self.rec_id = rec_id_list[0:]

            # print "self.rec_id", self.rec_id
            if self.rec_id == "espdr_cal_contam":
                self.rec_subtitle = "Fibre Contamination Computation. "

        # This function creates all the subplots. It is responsible for the plotting
        # layouts.
        # There can different layouts, depending on the availability of data
        # Note that subplot(I,J,K) means the Kth plot in a IxJ grid
        # Note also that the last one is actually a box with text, no graphs.
        def addSubplots(self, figure):
            nrows = self.nima
            # print("scired:", self.contam_found)
            if self.contam_found == True:

                self.subplot_image = figure.add_subplot(3, 1, 1)
                self.subplot_spectrum = figure.add_subplot(3, 1, 2)
                self.subplot_scatter = figure.add_subplot(3, 1, 3)
                # self.fibre_selector = figure.add_axes([0.85, 0.44, 0.10, 0.10])
                # self.product_selector = figure.add_axes([0.63, 0.58, 0.50, 0.18],aspect='equal')
                self.product_selector = figure.add_axes([0.01, 0.92, 0.22, 0.08])
                self.order_selector = figure.add_axes([0.10, 0.65, 0.35, 0.02])
                # self.qc_selector = figure.add_axes([0.10, 0.30, 0.25, 0.05])

            else:
                self.subtext_nodata = figure.add_subplot(1, 1, 1)

        def plotWidgets(self):
            widgets = list()
            if self.contam_found == True:
                labels_prod = self.labels_prod
                self.radiobutton_pro = reflex_plot_widgets.InteractiveRadioButtons(self.product_selector,
                                                                                   self.setProductSelectCallBack,
                                                                                   labels_prod, 0, title="")
                widgets.append(self.radiobutton_pro)

                min = 0
                val = self.x_id
                val = self.order_id

                max = self.ima_sx
                max = self.ima_sy
                title_slider = "Select order id by clicking with mouse left button"
                self.slider = espdr_discrete_slider.InteractiveSlider2(self.order_selector, self.setXSelectCallBack,
                                                                       min, max, val, 1, "order no")

                widgets.append(self.slider)

            return widgets

        def setXSelectCallBack(self, x_id):

            self.x_id = int(x_id)
            self.order_id = int(x_id)
            self.subplot_spectrum.cla()
            self.plotSpectrum()

        def setProductSelectCallBack(self, product_id):
            self.product_id = product_id
            # print("product_id:", self.product_id)
            p_len = len(self.product_id)

            self.subplot_image.cla()
            self.subplot_spectrum.cla()
            self.plotImage()
            self.plotSpectrum()

        def setTitleObject(self):
            # print("product_id:",self.product_id)
            if self.product_id == 'CONTAM_S2D_A':
                object = '[S2D Spectrum]'
            elif self.product_id == 'CONTAM_S2D_B':
                object = '[S2D Spectrum]'
            elif self.product_id == 'CONTAM_FP':
                object = '[Raw Image]'
            elif self.product_id == 'CONTAM_THAR':
                object = '[Raw Image]'
            self.title_object = object

        def preparePlotImage(self):
            # print("product_id:",self.product_id)
            if self.product_id == 'CONTAM_S2D_A':
                self.obj = self.contam_s2d_a
                self.spc = self.contam_s2d_a
            elif self.product_id == 'CONTAM_S2D_B':
                self.obj = self.contam_s2d_b
                self.spc = self.contam_s2d_b
            elif self.product_id == 'CONTAM_FP':
                self.obj = self.contam_fp
                self.spc = self.contam_fp
            elif self.product_id == 'CONTAM_THAR':
                self.obj = self.contam_thar
                self.spc = self.contam_thar

        def preparePlotQC(self):
            pass

        def prepTitleAndTooltipImage(self):
            title_pref = 'Linear-extracted and Merged Spectrum.'

            self.tooltip_spectrum = """\
        Plot of the extracted spectrum corresponding to the order number
        indicated by the slider located above the plot title.
         """

            title_spectrum = title_pref
            # print('check product_id',self.product_id)
            if self.product_id == 'CONTAM_S2D_A':
                self.spec_frame = 'Fib. Contam. Frame fib A '
            elif self.product_id == 'CONTAM_S2D_B':
                self.spec_frame = 'Fib. Contam. Frame fib B '
            elif self.product_id == 'CONTAM_FP':
                self.spec_frame = 'Fib. Contam. Frame fib A '
            elif self.product_id == 'CONTAM_THAR':
                self.spec_frame = 'Fib. Contam. Frame fib A '
            self.tooltip_frameON = """\
           Bias corrected fibre contamination image (wavelength,order). 
           """

            self.setTitleObject()
            self.title_frame = self.spec_frame + self.title_object + ' QC CHECK:%#.1d' % (self.qc_contam_check)

        def plotImage(self):
            s1da_title = "Spectrum Fibre A"
            s1da_tooltip = "Green: rebinned data; blue: equalized data.\n" \
                           "Click twice to change the wavelength range.\n" \
                           "Double-click to use the full wavelength range."
            s1da_y_label = r"Flux density [erg $\mathdefault{cm^2}$ " \
                           r"$\mathdefault{s^{-1}}$ $\mathdefault{nm^{-1}}$]"
            s1db_title = "Spectrum Fibre B"
            s1db_tooltip = "Grey: non-rebinned data; green: rebinned data; blue: " \
                           "equalized data."
            s1db_y_label = r"SNR / pixel size [$\mathdefault{nm^{-1}}$]"
            all_x_label = "Wavelength [nm]"

            self.prepTitleAndTooltipImage()
            self.preparePlotImage()
            self.dpm.plotImageOnly(self.obj, self.ext_ima, self.binx, self.biny, 'X [pix]', 'Order number',
                                   self.subplot_image, self.title_frame, self.tooltip_frameON)

        def plotSpectrum(self):
            if self.product_id == 'CONTAM_FP':
                xLab = 'Y [pix]'
            elif self.product_id == 'CONTAM_THAR':
                xLab = 'Y [pix]'
            else:
                xLab = 'X [pix]'

            self.dpm.plotImageSlice2(self.spc, self.spc, self.order_id, self.subplot_spectrum, self.title_frame,
                                     self.tooltip_spectrum, xLab, 'ADU')

        def plotQC(self):
            x = self.order_nb_a
            y = self.max_flux
            xLab = 'Order number'
            yLab = 'max flux [ADU]'
            title = 'Max flux (contamination) fib A vs order number'
            tooltip = 'Plot of ' + title
            self.dpm.scatterPlotScatter3(self.subplot_scatter, x, y, xLab, yLab, title, tooltip, 1)

        def caseNodata(self):
            # Data not found info
            self.subtext_nodata.set_axis_off()
            self.text_nodata = """\
                           ON-frame, Residual table 
                           (PRO.CATG=PREF_ON_ARM,PREF_RESID_ARM, 
                           where PREF=FMTCHK, ORDEF, FLAT, or WAVE, 
                           ARM=UVB,VIS or NIR) not found in the products. 
                           This may be due to a recipe failure. 
                           Check your input parameter values, 
                           correct possibly typos and
                           press 'Re-run recipe' button."""
            self.subtext_nodata.text(0.1, 0.6, self.text_nodata, color='#11557c',
                                     fontsize=18, ha='left', va='center', alpha=1.0)
            self.subtext_nodata.tooltip = """\
                                    Merged spectrum not found in the products"""

        # This is the function that makes the plots.
        # Add new plots or delete them using the given scheme.
        # The data has been already stored in self.plot_x, self.plot_xdif, etc ...
        # It is mandatory to add a tooltip variable to each subplot.
        # One might be tempted to merge addSubplots() and plotProductsGraphics().
        # There is a reason not to do it: addSubplots() is called only once at
        # startup, while plotProductsGraphics() is called always there is a resize.
        def plotProductsGraphics(self):
            if (self.contam_found == True):

                self.prepTitleAndTooltipImage()
                self.preparePlotImage()

                sx = self.obj.all_hdu[self.ext_ima].header['NAXIS1']
                sy = self.obj.all_hdu[self.ext_ima].header['NAXIS2']
                self.ima_sx = sx
                self.ima_sy = sy

                self.dpm = espdr_plot_common.DataPlotterManager()
                self.plotImage()
                self.plotSpectrum()
                self.plotQC()

            else:
                self.caseNodata()

        # This function specifies which are the parameters that should be presented
        # in the window to be edited.
        # Note that the parameter has to be also in the in_sop port (otherwise it
        # won't appear in the window)
        # The descriptions are used to show a tooltip. They should match one to one
        # with the parameter list
        # Note also that parameters have to be prefixed by the 'recipe name:'

        def setInteractiveParameters(self):
            paramList = list()
            rec_id = self.rec_id
            self.par = espdr_parameters_common.Parameters()
            # self.par.setGeneralCalibParameters(paramList,rec_id)
            if rec_id == "espdr_cal_contam":
                self.par.setContamParameters(paramList, "espdr_cal_contam", "all")

            else:
                print("recipe", rec_id, "not supported")

            return paramList

        def setWindowHelp(self):
            help_text = """
This is an interactive window which help asses the quality of the execution of a recipe.
"""
            return help_text

        def setWindowTitle(self):
            title = self.instrume + ' Interactive Workflow: ' + self.rec_subtitle
            return title

except ImportError:
    import_sucess = 'false'
    print("Error importing modules pyfits, wx, matplotlib, numpy")
    raise

# This is the 'main' function
if __name__ == '__main__':

    # import reflex modules
    from reflex import *
    from reflex_interactive_app import *
    from pipeline_display import *
    from pipeline_product import *

    # Create interactive application
    interactive_app = PipelineInteractiveApp(enable_init_sop=True)

    # PECULIAR XSH needs this in order to be able later to get from an input FITS
    # the ins-mode, arm (and recipe) IDs, used in titles and param setting
    # get inputs from the command line
    interactive_app.parse_args()
    inputs = interactive_app.inputs
    # (inputs, args) = interactive_app.parse_args()

    # Check if import failed or not
    if import_sucess == 'false':
        interactive_app.setEnableGUI(false)

    # interactive_app.setEnableGUI(True)
    # Open the interactive window if enabled
    if interactive_app.isGUIEnabled():
        # Get the specific functions for this window
        dataPlotManager = DataPlotterManager()
        # print inputs.in_sof
        # dataPlotManager.checkSofIsNotEmpty(inputs.in_sof)
        # With the following call XSH get the: ins-mode, arm (and recipe) IDs
        dataPlotManager.getArmId(inputs.in_sof)
        # Set recipe ID in order to build proper param list, display layout
        dataPlotManager.setRecId("espdr_cal_contam")
        interactive_app.setPlotManager(dataPlotManager)
        interactive_app.showGUI()
    else:
        interactive_app.passProductsThrough()

    # Print outputs. This is parsed by the Reflex python actor to get the results
    # Do not remove
    interactive_app.print_outputs()
    sys.exit()
