# ESPDR_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([ESPDR_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


AC_DEFUN([ESPDR_SET_ERFA_LOCATION],
[
    AC_ARG_WITH(erfa,
                AS_HELP_STRING([--with-erfa],
                               [location where erfa is installed]),
                [
                    erfa_dir=$withval
                ])

    if test -n "$erfa_dir"; then
        ac_configure_args="$ac_configure_args --with-erfa=$erfa_dir"
    elif test -n "$ERFADIR"; then
        ac_configure_args="$ac_configure_args --with-erfa=$ERFADIR"
    fi
])

# ESPDR_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([ESPDR_SET_VERSION_INFO],
[
    espdr_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    espdr_major_version=`echo "$espdr_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    espdr_minor_version=`echo "$espdr_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    espdr_micro_version=`echo "$espdr_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$espdr_major_version"; then espdr_major_version=0
    fi

    if test -z "$espdr_minor_version"; then espdr_minor_version=0
    fi

    if test -z "$espdr_micro_version"; then espdr_micro_version=0
    fi

    ESPDR_VERSION="$espdr_version"
    ESPDR_MAJOR_VERSION=$espdr_major_version
    ESPDR_MINOR_VERSION=$espdr_minor_version
    ESPDR_MICRO_VERSION=$espdr_micro_version

    if test -z "$4"; then ESPDR_INTERFACE_AGE=0
    else ESPDR_INTERFACE_AGE="$4"
    fi

    ESPDR_BINARY_AGE=`expr 100 '*' $ESPDR_MINOR_VERSION + $ESPDR_MICRO_VERSION`
    ESPDR_BINARY_VERSION=`expr 10000 '*' $ESPDR_MAJOR_VERSION + \
                          $ESPDR_BINARY_AGE`

    AC_SUBST(ESPDR_VERSION)
    AC_SUBST(ESPDR_MAJOR_VERSION)
    AC_SUBST(ESPDR_MINOR_VERSION)
    AC_SUBST(ESPDR_MICRO_VERSION)
    AC_SUBST(ESPDR_INTERFACE_AGE)
    AC_SUBST(ESPDR_BINARY_VERSION)
    AC_SUBST(ESPDR_BINARY_AGE)

    AC_DEFINE_UNQUOTED(ESPDR_MAJOR_VERSION, $ESPDR_MAJOR_VERSION,
                       [ESPDR major version number])
    AC_DEFINE_UNQUOTED(ESPDR_MINOR_VERSION, $ESPDR_MINOR_VERSION,
                       [ESPDR minor version number])
    AC_DEFINE_UNQUOTED(ESPDR_MICRO_VERSION, $ESPDR_MICRO_VERSION,
                       [ESPDR micro version number])
    AC_DEFINE_UNQUOTED(ESPDR_INTERFACE_AGE, $ESPDR_INTERFACE_AGE,
                       [ESPDR interface age])
    AC_DEFINE_UNQUOTED(ESPDR_BINARY_VERSION, $ESPDR_BINARY_VERSION,
                       [ESPDR binary version number])
    AC_DEFINE_UNQUOTED(ESPDR_BINARY_AGE, $ESPDR_BINARY_AGE,
                       [ESPDR binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# ESPDR_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([ESPDR_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)

    # evaluate $libdir -> $exec_prefix/lib -> full path, for maintainer mode
    eval private_libdir="$privatelibdir"
    eval private_libdir="$private_libdir"
    # override directories in bepop subconfigure
    # install all bepop files into private dir we only need the data,
    # static linked so also libdir can be changed
    #
    # using these flags in main configure will break this
    # alternative, use BEPOPPREFIX=${private_libdir} and modify bepop
    # configure.ac to set the directories from that
    ac_configure_args="$ac_configure_args --includedir=${private_libdir} --datadir=${private_libdir} --infodir=${private_libdir} --bindir=${private_libdir} --libdir=${private_libdir}"


    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(ESPDR_PLUGIN_DIR, "${PACKAGE}/plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(ESPDR_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

])


# ESPDR_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([ESPDR_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    ESPDR_INCLUDES='-I$(top_srcdir)/espdr -I$(top_srcdir)/hdrl'
    ESPDR_LDFLAGS='-L$(top_builddir)/espdr'

    # Library aliases

    BEPOP_INCLUDES='-I$(top_srcdir)/libbepop -I$(top_srcdir)/libbepop/src'
    BEPOP_LDFLAGS=""


    LIBESPDR='$(top_builddir)/espdr/libespdr.la'
    LIBHDRL='$(top_builddir)/hdrl/libhdrl.la' 

    # Substitute the defined symbols

    AC_SUBST(ESPDR_INCLUDES)
    AC_SUBST(ESPDR_LDFLAGS)

    AC_SUBST(LIBESPDR)
    AC_SUBST(HDRL_INCLUDES)

    # Check for CPL and user defined libraries
    AC_REQUIRE([ESO_PROG_PKGCONFIG])
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(ESPDR_INCLUDES) $(CPL_INCLUDES) $(GSL_INCLUDES) $(EXTRA_INCLUDES) $(XXCLIPM_INCLUDES)'
    all_ldflags='$(ESPDR_LDFLAGS) $(CPL_LDFLAGS) $(GSL_LDFLAGS) $(EXTRA_LDFLAGS) $(XXCLIPM_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
