from __future__ import absolute_import
from __future__ import print_function
try:
    import matplotlib
    import numpy as np
    from matplotlib.widgets import Slider
except ImportError:
    import matplotlib
    import numpy as np
    from matplotlib.widgets import Slider
    pass
    

class CallableWidget:
    """This class is used as a base class for reflex widgets
    It will allow to add a hook to the callback function that is executed
    after the main callback functionality."""
    def __init__(self):
        self.postcallback = None

    def setPostCallback(self, postcallback):
        self.postcallback = postcallback

    def postCallback(self, new_params):
        if self.postcallback is not None:
            self.postcallback(new_params)
        

class InteractiveSlider2(CallableWidget):
    """This class will create a slider in a matplotlib canvas
    allowing the creator to specify a callback function to be called when
    a slider position is selected."""
    def __init__(self, axes, callback, valmin, valmax, valinit, increment, label=""):
        CallableWidget.__init__(self)
        self.inc = increment
        # print('increment=',self.inc)
        self.slider = matplotlib.widgets.Slider(axes, label, valmin, valmax, valinit=valinit, dragging=True, valfmt='%d')
        sl_xticks = np.arange(valmin, valmax, 10)
        axes.set_xticks(sl_xticks) 
        axes.xaxis.set_ticklabels([])
        self.slider.on_changed(self.__callback)
        self.usercallback = callback        
        
    def __callback(self, slider_pos):
        discrete_pos = round(slider_pos / self.inc) * self.inc
        new_params = self.usercallback(discrete_pos)
        self.postCallback(new_params)
