

# PIONIER_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([PIONIER_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])

# PIONIER_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([PIONIER_SET_VERSION_INFO],
[
    pionier_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    pionier_major_version=`echo "$pionier_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    pionier_minor_version=`echo "$pionier_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    pionier_micro_version=`echo "$pionier_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$pionier_major_version"; then pionier_major_version=0
    fi

    if test -z "$pionier_minor_version"; then pionier_minor_version=0
    fi

    if test -z "$pionier_micro_version"; then pionier_micro_version=0
    fi

    PIONIER_VERSION="$pionier_version"
    PIONIER_MAJOR_VERSION=$pionier_major_version
    PIONIER_MINOR_VERSION=$pionier_minor_version
    PIONIER_MICRO_VERSION=$pionier_micro_version

    if test -z "$4"; then PIONIER_INTERFACE_AGE=0
    else PIONIER_INTERFACE_AGE="$4"
    fi

    PIONIER_BINARY_AGE=`expr 100 '*' $PIONIER_MINOR_VERSION + $PIONIER_MICRO_VERSION`
    PIONIER_BINARY_VERSION=`expr 10000 '*' $PIONIER_MAJOR_VERSION + \
                          $PIONIER_BINARY_AGE`

    AC_SUBST(PIONIER_VERSION)
    AC_SUBST(PIONIER_MAJOR_VERSION)
    AC_SUBST(PIONIER_MINOR_VERSION)
    AC_SUBST(PIONIER_MICRO_VERSION)
    AC_SUBST(PIONIER_INTERFACE_AGE)
    AC_SUBST(PIONIER_BINARY_VERSION)
    AC_SUBST(PIONIER_BINARY_AGE)

    AC_DEFINE_UNQUOTED(PIONIER_MAJOR_VERSION, $PIONIER_MAJOR_VERSION,
                       [PIONIER major version number])
    AC_DEFINE_UNQUOTED(PIONIER_MINOR_VERSION, $PIONIER_MINOR_VERSION,
                       [PIONIER minor version number])
    AC_DEFINE_UNQUOTED(PIONIER_MICRO_VERSION, $PIONIER_MICRO_VERSION,
                       [PIONIER micro version number])
    AC_DEFINE_UNQUOTED(PIONIER_INTERFACE_AGE, $PIONIER_INTERFACE_AGE,
                       [PIONIER interface age])
    AC_DEFINE_UNQUOTED(PIONIER_BINARY_VERSION, $PIONIER_BINARY_VERSION,
                       [PIONIER binary version number])
    AC_DEFINE_UNQUOTED(PIONIER_BINARY_AGE, $PIONIER_BINARY_AGE,
                       [PIONIER binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# PIONIER_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([PIONIER_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    if test -z "$workflowdir"; then
        workflowdir='${datadir}/esopipes/workflows/${PACKAGE}-${VERSION}/${PACKAGE}'
    fi
 
    if test -z "$reportsdir"; then
       reportsdir='${datadir}/esopipes/reports/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(reportsdir)
    AC_SUBST(workflowdir)

    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(PIONIER_PLUGIN_DIR, "${PACKAGE}/plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/esopipes-plugins\/${PACKAGE}-${VERSION}.*$/esopipes-plugins/"`

    AC_DEFINE_UNQUOTED(PIONIER_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

    eval privatelib_dir="$privatelibdir"
    privatelib_path=`eval echo $privatelib_dir`

    AC_DEFINE_UNQUOTED(PIONIER_PRIVATELIB_PATH, "$privatelib_path",
                       [Absolute path to the privatelib directory tree])



])


# PIONIER_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([PIONIER_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    PIONIER_INCLUDES='-I$(top_srcdir)/pionier -I$(top_srcdir)/hdrl'
    PIONIER_LDFLAGS='-L$(top_builddir)/pionier'

    # Library aliases

    LIBHDRL='$(top_builddir)/hdrl/libhdrl.la'
    LIBPIONIER='$(top_builddir)/pionier/libpionier.la'

    # Substitute the defined symbols

    AC_SUBST(PIONIER_INCLUDES)
    AC_SUBST(PIONIER_LDFLAGS)

    AC_SUBST(LIBHDRL)
    AC_SUBST(LIBPIONIER)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])

    all_includes='$(PIONIER_INCLUDES) $(CPL_INCLUDES)'
    all_ldflags='$(PIONIER_LDFLAGS) $(CPL_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])


# PNDRS_SET_PATHS
#------------------
AC_DEFUN([PNDRS_SET_PATHS],
[

    if test -z "$pndrsdir"; then
        pndrsdir='${libdir}/${PACKAGE}-${VERSION}/pndrs/'
    fi

    AC_SUBST(pndrsdir)

    # Define preprocesor symbols for the pndrs and pndrs programs.

    eval pndrs_dir="$pndrsdir"
	pndrs_path=`eval echo $pndrs_dir`
 
    AC_DEFINE_UNQUOTED(PNDRS_DIR, "$pndrs_path",
                       [Absolute path to the Pndrs directory])

])
