/*
 * This file is part of the PIONIER pipeline
 * Copyright (C) 2012,2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  Created on: Nov 30, 2012
 *      Author: agabasch
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                                                Includes
 -----------------------------------------------------------------------------*/

#include "pioni_dfs.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup pioni_dfs  DFS related functions
 *
 * TBD
 */
/*----------------------------------------------------------------------------*/

/**@{*/

/*----------------------------------------------------------------------------*/
/**
 * @brief    Set the group as RAW or CALIB in a frameset
 * @param    set     the input frameset
 * @return
 *   The function returns @c CPL_ERROR_NONE on success or a CPL error
 *   code otherwise.
 */
/*----------------------------------------------------------------------------*/
cpl_error_code pioni_dfs_set_groups(cpl_frameset * set)
{
    cpl_frame   *   cur_frame;
    const char  *   tag;
    int             nframes;
    int             i;
    /* Check entries */
    cpl_ensure_code(set != NULL, CPL_ERROR_NULL_INPUT);

    /* Initialize */
    nframes = cpl_frameset_get_size(set);

    /* Loop on frames */
    for (i = 0; i < nframes; i++) {
        cur_frame = cpl_frameset_get_position(set, i);
        tag = cpl_frame_get_tag(cur_frame);
        /* RAW frames */
        if (!strcmp(tag, PIONIER_SPEC_CAL) || 
                !strcmp(tag, PIONIER_DARK) ||
                !strcmp(tag, PIONIER_BIAS) ||
                !strcmp(tag, PIONIER_KAPPA) ||
                !strcmp(tag, PIONIER_DETMON) ||
                !strcmp(tag, PIONIER_DETMON_ERROR) ||
                !strcmp(tag, PIONIER_DETMON_BPM) ||
            !strcmp(tag, PIONIER_FRINGE) ||
            !strcmp(tag, PIONIER_CALIB_OIDATA_RAW) ||
            !strcmp(tag, PIONIER_TARGET_OIDATA_RAW))
            cpl_frame_set_group(cur_frame, CPL_FRAME_GROUP_RAW);
        /* CALIB frames */
        else if (!strcmp(tag, PIONIER_SPECTRAL_CALIBRATION) ||
                !strcmp(tag, PIONIER_DARK_CALIBRATION) ||
                !strcmp(tag, PIONIER_KAPPA_MATRIX) ||
                !strcmp(tag, PIONIER_STATIC_MASK) ||
                !strcmp(tag, PIONIER_JSDC_CAT) ||
                !strcmp(tag, PIONIER_OIDATA_TF))
                cpl_frame_set_group(cur_frame, CPL_FRAME_GROUP_CALIB);
    }
    return cpl_error_get_code();
}

/**@}*/


