/*
 * This file is part of the PIONIER pipeline
 * Copyright (C) 2012,2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  Created on: Nov 30, 2012
 *      Author: agabasch
 */

#ifndef PIONIER_DFS_H_
#define PIONIER_DFS_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

/* Raw-frames */
#define PIONIER_SPEC_CAL              "SPEC_CAL"
#define PIONIER_DARK                  "DARK"
#define PIONIER_BIAS                  "BIAS"
#define PIONIER_KAPPA                 "KAPPA"
#define PIONIER_FRINGE                "FRINGE"
#define PIONIER_DETMON                "DETMON"
#define PIONIER_DETMON_ERROR          "DETMON_ERROR"
#define PIONIER_DETMON_BPM            "DETMON_BPM"

/* product-frames */
#define PIONIER_SPECTRAL_CALIBRATION  "SPECTRAL_CALIBRATION"
#define PIONIER_DARK_CALIBRATION      "DARK_CALIBRATION"
#define PIONIER_KAPPA_MATRIX          "KAPPA_MATRIX"
#define PIONIER_CALIB_OIDATA_RAW      "CALIB_OIDATA_RAW"
#define PIONIER_TARGET_OIDATA_RAW     "TARGET_OIDATA_RAW"
#define PIONIER_OIDATA_TF             "OIDATA_TF"

/* static-frames */
#define PIONIER_JSDC_CAT              "JSDC_CAT"
#define PIONIER_STATIC_MASK           "STATIC_MASK"

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code pioni_dfs_set_groups(cpl_frameset * set);

CPL_END_DECLS

#endif /* PIONIER_DFS_H_ */
