from adari_core.data_libs.master_interfer_calib import MasterInterferCalibReport
from adari_core.plots.text import TextPlot
from adari_core.utils.utils import fetch_kw_or_default

from .pionier_utils import PionierSetupInfo, PionierReportMixin
from .pionier_utils import find_ext_index


class PionierTransferFunctionReport(PionierReportMixin, MasterInterferCalibReport):
    def __init__(self):
        super().__init__("pionier_tf")

    def parse_sof(self):

        tf_file = None

        for filename, catg in self.inputs:
            if catg == "OIDATA_TF":
                tf_file = filename

        file_lists = []
        if tf_file is not None:
            file_lists.append(
                {
                    "oi_data": tf_file,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):

        oi_data_ext = "OI_VIS2"
        vspace = 0.4
        tf = self.hdus[0]["oi_data"]
        oi_data_iext = find_ext_index(tf, oi_data_ext)

        panels = super().generate_panels(
            oi_ext_list=oi_data_iext, y_label="TF", y_lim="lim", **kwargs
        )

        for panel, panel_descr in panels.items():
            i_ext = panel_descr["ext"]
            mdata_hdul = self.hdus[0]["oi_data"]
            mdata_ext = "PRIMARY"
            t0 = TextPlot(columns=1, v_space=vspace)
            col0 = (
                "INSTRUME: " + str(mdata_hdul[mdata_ext].header.get("INSTRUME")),
                "EXTNAME: " + oi_data_ext,
                "INSNAME: "
                + str(
                    fetch_kw_or_default(mdata_hdul[i_ext], "INSNAME", default="N/A")
                ).split("(")[0],
                "PRO.CATG: "
                + str(
                    fetch_kw_or_default(
                        mdata_hdul[mdata_ext], "HIERARCH ESO PRO CATG", default="N/A"
                    )
                ),
                "FILE NAME: "
                + str(
                    fetch_kw_or_default(
                        mdata_hdul[mdata_ext],
                        "HIERARCH ESO PRO REC1 CAL1 NAME",
                        default="N/A",
                    )
                ),
                "RAW1 NAME: "
                + str(
                    fetch_kw_or_default(
                        mdata_hdul[mdata_ext],
                        "HIERARCH ESO PRO REC1 RAW1 NAME",
                        default="N/A",
                    )
                ),
            )
            t0.add_data(col0)
            panel.assign_plot(t0, 0, 0, xext=1)

            metadata1 = PionierSetupInfo.fringes(mdata_hdul)
            t1 = TextPlot(columns=1, v_space=vspace, xext=1)
            col1 = metadata1
            t1.add_data(col1)
            panel.assign_plot(t1, 2, 0, xext=1)

            metadata2 = PionierSetupInfo.calibrator_fringes(mdata_hdul)
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = metadata2[-2:]
            t2.add_data(col2)
            panel.assign_plot(t2, 4, 0, xext=1)

        return panels


rep = PionierTransferFunctionReport()
