from edps import data_source, match_rules
from edps.generator.time_range import *

from .pionier_classification import *

# Data sources
# Convention for Data sources Association rule levels:
# Each data source can have several match function which correspond to different
# quality levels for the selected data. The level is specified as a number that
# follows this convention:
#   level < 0: more restrictive than the calibration plan
#   level = 0 follows the calibration plan
#   level = 1 quality sufficient for QC1 certification
#   level = 2 probably still acceptable quality
#   level = 3 significant risk of bad quality results

# general keywords
instrument = [kwd.instrume]
inst_keys = [kwd.ins_opti2_name, kwd.ins_filt1_name]
read_out_keys = [kwd.det_read_out_mode, kwd.det_read_out_nsamppix]
det_keys = [kwd.det_scann_readds, kwd.det_subwins, kwd.det_dit, kwd.det_polar]
# DET.SUBWINS,DET.SUBWIN1.GEOMETRY,DET.POLAR,INS.OPTI2.NAME
# grouping keywords:

group_bias = [kwd.tpl_start, kwd.det_polar, kwd.det_name]
group_kappa = [kwd.tpl_start, kwd.ins_mode, kwd.det_subwins, kwd.det_subwin1_geometry, kwd.det_polar,
               kwd.ins_opti2_name]
group_wave = read_out_keys + det_keys + [kwd.tpl_start]
# matching keywords:
match_darks = inst_keys + read_out_keys
match_wave = inst_keys
match_kappa = inst_keys + [kwd.det_polar]
match_calib_fringe = inst_keys + [kwd.obs_container_id]
setup = [kwd.det_subwins, kwd.det_subwin1_geometry, kwd.det_polar, kwd.ins_opti2_name, kwd.ins_mode]
# --- Datasources ------------------------------------------------------------------------
# - Bias datasources ---
raw_bias_pixchar = (data_source()
                    .with_classification_rule(bias_pixchar_class)
                    .with_grouping_keywords([kwd.tpl_start])
                    .build())

raw_bias = (data_source("BIAS")
            .with_classification_rule(bias_detchar_class)
            .with_classification_rule(bias_detmon_class)
            .with_setup_keywords([kwd.det_polar, kwd.det_name])
            .with_grouping_keywords(group_bias)
            .build())
# ---

# Dark DatasourcesDET.SUBWINS,DET.SUBWIN1.GEOMETRY,DET.POLAR,INS.OPTI2.NAME
raw_dark = (data_source()
            .with_classification_rule(dark_class)
            .with_grouping_keywords([kwd.arcfile])
            .with_setup_keywords([kwd.det_subwins, kwd.det_subwin1_geometry, kwd.det_polar, kwd.ins_opti2_name])
            .with_match_keywords(match_darks, time_range=RelativeTimeRange(-0.05, 1), level=0)
            .with_match_keywords(match_darks, time_range=RelativeTimeRange(-0.3, 1), level=1)
            .with_match_keywords(match_darks, time_range=ONE_DAY, level=2)
            .with_match_keywords(match_darks, time_range=UNLIMITED, level=3)
            .build())

# Fringe tasks want the darks to be closer in time.
match_close_dark = (match_rules()
                    .with_match_keywords(match_darks, time_range=RelativeTimeRange(-0.05, 1), level=0)
                    .with_match_keywords(match_darks, time_range=RelativeTimeRange(-0.1, 1), level=1)
                    .with_match_keywords(match_darks, time_range=RelativeTimeRange(-0.3, 0.3), level=2)
                    .with_match_keywords(match_darks, time_range=UNLIMITED, level=3))

# Datasource for wavelength spectral calibrations
raw_wave_spec = (data_source("WAVE_LAMP")
                 .with_classification_rule(wave_spec_class)
                 .with_grouping_keywords(group_wave)
                 .with_setup_keywords(setup)
                 .with_match_keywords(inst_keys, time_range=ONE_DAY, level=0)
                 .with_match_keywords(inst_keys, time_range=UNLIMITED, level=3)
                 .build())

# Some tasks want the wavelength calibrations closer in time
match_close_wave = (match_rules()
                    .with_match_keywords(inst_keys, time_range=RelativeTimeRange(-0.8, 0.8), level=0)
                    .with_match_keywords(inst_keys, time_range=UNLIMITED, level=3))

# Datasource for kappa matrix (interferometric transmission)
raw_kappa_matrix = (data_source()
                    .with_classification_rule(kappa_matrix_class)
                    .with_grouping_keywords(group_kappa)
                    .with_min_group_size(4)
                    .with_setup_keywords(setup + [kwd.telescop])
                    .with_match_keywords(match_kappa, time_range=RelativeTimeRange(-0.05, 1), level=0)
                    .with_match_keywords(match_kappa, time_range=RelativeTimeRange(-0.8, 1), level=1)
                    .with_match_keywords(match_kappa, time_range=UNLIMITED, level=3)
                    .build())

# Datasource for interferometric fringes
raw_int_fringe = (data_source("FLAT_LAMP")
                  .with_classification_rule(int_fringe_class)
                  .with_setup_keywords(setup)
                  .with_grouping_keywords([kwd.arcfile])
                  .build())

# Datasource for calibration fringes
raw_calib_fringe = (data_source("CALIBRATOR")
                    .with_classification_rule(calib_fringe_class)
                    .with_grouping_keywords([kwd.arcfile])
                    .with_setup_keywords(setup + [kwd.telescop])
                    .with_match_keywords(match_calib_fringe, time_range=RelativeTimeRange(-0.05, 1), level=0)
                    .with_match_keywords(match_calib_fringe, time_range=ONE_DAY, level=2)
                    .build())

# Datasource for raw science
raw_science = (data_source("SCIENCE")
               .with_classification_rule(science_class)
               .with_setup_keywords(setup + [kwd.telescop])
               .with_grouping_keywords([kwd.tpl_start])
               .build())

# --- Datasources for static calibrations ------------------------------------------------
# Reference frames
static_mask = (data_source()
               .with_classification_rule(static_mask_class)
               .with_match_keywords(instrument, time_range=IN_THE_PAST, level=0)
               .with_match_keywords(instrument, time_range=UNLIMITED, level=3)
               .build())
# Catalogue
jsdc_cat = (data_source()
            .with_classification_rule(jsdc_cat_class)
            .with_match_keywords(instrument, time_range=IN_THE_PAST, level=0)
            .with_match_keywords(instrument, time_range=UNLIMITED, level=3)
            .build())
