from edps import task, QC1_CALIB, subworkflow

from .pionier_datasources import *


@subworkflow("detector monitoring", "")
# This subworkflow contains the tasks that are used for instrument monitoring. The products are not used
# in the reduction cascade.

def monitoring():
    # Raw bias_pixchar are not used in the reduction flow and they are not processed by any recipe.
    bias_pixchar = (task('bias_pixchar')
                    .with_main_input(raw_bias_pixchar)
                    .build())

    # Raw bias_detector are processed by the pioni_detmon recipe to check for bad pixels and monitor the gain.
    # Its product are used to monitor the detector using quality control parameters, but they are not used
    # in the reduction flow.
    detector_monitor = (task('detector_monitor')
                        .with_recipe('pioni_detmon')
                        .with_main_input(raw_bias)
                        .with_associated_input(static_mask, min_ret=0)
                        .with_meta_targets([QC1_CALIB])
                        .build())

    return bias_pixchar, detector_monitor
