/*
 * This file is part of the PIONIER pipeline
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PIONIER_UTILS_H_
#define PIONIER_UTILS_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "hdrl.h"

/* TMP */
#include "hdrl_iter.h"

#include <string.h>
#include <math.h>
#include <cpl.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/



cpl_error_code pioni_hdrl_image_load(
        cpl_frame       *   in,
        cpl_size            ext_num,
        cpl_frame       *   in_err,
        cpl_size            ext_num_err,
        cpl_frame       *   in_bpm,
        cpl_size            ext_num_bpm,
        hdrl_parameter  *   rect_region,
        double              ron,
        double              gain,
        hdrl_image      **  out_hdrl_ima) ;


cpl_error_code
pioni_detector_shotnoise_model(const cpl_image* ima_data,
                                  const double conad,
                                  const double ron,
                                  cpl_image ** ima_errs);
int
pioni_get_naxis1(const cpl_propertylist * plist);

int
pioni_get_naxis2(const cpl_propertylist * plist);

cpl_error_code
pioni_cleanup_primary(cpl_propertylist* proplist_yorick_primary);

cpl_error_code savetype_cpl_to_oifit(cpl_table * table);

CPL_END_DECLS

#endif /* PIONIER_UTILS_H_ */
