import logging
from adari_core.utils.utils import fetch_kw_or_default

logger = logging.getLogger(__name__)


class PionierReportMixin(object):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._version = "4.0.0"

class PionierSetupInfo:

    @staticmethod
    def fringes(hdul):
        metadata = [
            "INS.OPTI2.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS OPTI2 NAME", default="N/A"
                )
            ),
            "DET.POLAR: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET POLAR", default="N/A"
                )
            ),
            "DET.SUBWINS: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET SUBWINS", default="N/A"
                )
            ),
            "DET.DIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET DIT", default="N/A"
                )
            ),
            "DET.NDIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET NDIT", default="N/A"
                )
            ),
            "DET.SUBWIN1.GEOMETRY: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET SUBWIN1 GEOMETRY", default="N/A"
                )
            ),
        ]
        return metadata

    @staticmethod
    def calibrator_fringes(hdul):
        metadata = [
            "ISS.CONF.STATION1: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF STATION1", default="N/A"
                )
            ),
            "ISS.CONF.STATION2: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF STATION2", default="N/A"
                )
            ),
            "ISS.CONF.STATION3: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF STATION3", default="N/A"
                )
            ),
            "ISS.CONF.STATION4: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF STATION4", default="N/A"
                )
            ),
            "ISS.CONF.T1NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF T1NAME", default="N/A"
                )
            ),
            "ISS.CONF.T2NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF T2NAME", default="N/A"
                )
            ),
            "ISS.CONF.T3NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF T3NAME", default="N/A"
                )
            ),
            "ISS.CONF.T4NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO ISS CONF T4NAME", default="N/A"
                )
            ),
            "TELESCOP: "
            + str(fetch_kw_or_default(hdul["PRIMARY"], "TELESCOP", default="N/A")),
            "OBS.TARG.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO OBS TARG NAME", default="N/A"
                )
            ),
        ]
        return metadata

    @staticmethod
    def fringes_product(hdul):
        metadata = [
            "QC.DB.DIAM: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC DB DIAM", default="N/A"
                ),
                4,
            ),
            "QC.VIS12.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS12 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS13.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS13 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS14.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS14 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS23.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS23 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS24.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS24 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS34.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS34 AVG", default="N/A"
                ),
                4,
            ),
            "QC.VIS12.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS12 ERR", default="N/A"
                ),
                4,
            ),
            "QC.VIS13.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS13 ERR", default="N/A"
                ),
                4,
            ),
            "QC.VIS14.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS14 ERR", default="N/A"
                ),
                4,
            ),
            "QC.VIS23.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS23 ERR", default="N/A"
                ),
                4,
            ),
            "QC.VIS24.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS24 ERR", default="N/A"
                ),
                4,
            ),
            "QC.VIS34.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC VIS34 ERR", default="N/A"
                ),
                4,
            ),
            "QC.PHI123.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI123 AVG", default="N/A"
                ),
                4,
            ),
            "QC.PHI124.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI124 AVG", default="N/A"
                ),
                4,
            ),
            "QC.PHI134.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI134 AVG", default="N/A"
                ),
                4,
            ),
            "QC.PHI234.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI234 AVG", default="N/A"
                ),
                4,
            ),
            "QC.PHI123.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI123 ERR", default="N/A"
                ),
                4,
            ),
            "QC.PHI124.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI124 ERR", default="N/A"
                ),
                4,
            ),
            "QC.PHI134.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI134 ERR", default="N/A"
                ),
                4,
            ),
            "QC.PHI234.ERR: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC PHI234 ERR", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS12.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS12 AVG", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS13.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS13 AVG", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS14.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS14 AVG", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS23.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS23 AVG", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS24.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS24 AVG", default="N/A"
                ),
                4,
            ),
            "QC.TFVIS34.AVG: "
            + _digits(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO QC TFVIS34 AVG", default="N/A"
                ),
                4,
            ),
        ]
        return metadata

    @staticmethod
    def dark(hdul):
        metadata = [
            "INS.OPTI2.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS OPTI2 NAME", default="N/A"
                )
            ),
            "DET.POLAR: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET POLAR", default="N/A"
                )
            ),
            "DET.SUBWINS: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET SUBWINS", default="N/A"
                )
            ),
            "DET.DIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET DIT", default="N/A"
                )
            ),
            "DET.NDIT: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET NDIT", default="N/A"
                )
            ),
        ]
        return metadata

    @staticmethod
    def kappa(hdul):
        metadata = [
            "INS.OPTI2.NAME: "
            + str(
                fetch_kw_or_default(hdul, "HIERARCH ESO INS OPTI2 NAME", default="N/A")
            ),
            "DET.POLAR: "
            + str(fetch_kw_or_default(hdul, "HIERARCH ESO DET POLAR", default="N/A")),
            "OBS.TARG.NAME: "
            + str(
                fetch_kw_or_default(hdul, "HIERARCH ESO OBS TARG NAME", default="N/A")
            ),
        ]
        return metadata

    @staticmethod
    def spectral_calibration(hdul):
        metadata = [
            "INS.OPTI2.NAME: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO INS OPTI2 NAME", default="N/A"
                )
            ),
            "DET.POLAR: "
            + str(
                fetch_kw_or_default(
                    hdul["PRIMARY"], "HIERARCH ESO DET POLAR", default="N/A"
                )
            ),
        ]
        return metadata


def _digits(value, n):
    try:
        return f"{float(value):.{n}f}"
    except ValueError:
        return value


def find_ext_index(hdu, ext):
    ind = []
    list_info = hdu.info(output=False)
    for item in list_info:
        if item[1] == ext:
            ind.append(item[0])
    return ind
