from edps import classification_rule

from . import pionier_keywords as kwd
from . import pionier_rules as rules

# Dictionaries containing the values of header keywords that define calibrations and science data
pionier = {kwd.instrume: "PIONIER"}
test_keywords = {**pionier, kwd.pro_catg: None, kwd.dpr_catg: "TEST"}
calib_keywords = {**pionier, kwd.pro_catg: None, kwd.dpr_catg: "CALIB"}
science_keywords = {**pionier, kwd.pro_catg: None, kwd.dpr_catg: "SCIENCE"}

image_test_keywords = {**test_keywords, kwd.dpr_tech: "IMAGE"}
image_calib_keywords = {**calib_keywords, kwd.dpr_tech: "IMAGE"}
vlti_calib_keywords = {**calib_keywords, kwd.dpr_tech: "INTERFEROMETRY"}
vlti_science_keywords = {**science_keywords, kwd.dpr_tech: "INTERFEROMETRY"}

# Raw types
bias_pixchar_class = classification_rule(
    "BIAS_PIXCHAR", {**calib_keywords, kwd.dpr_type: "PTC,BIAS,PIXCHAR"}
)
bias_detmon_class = classification_rule("BIAS", rules.is_bias_detmon)
bias_detchar_class = classification_rule("DETMON", rules.is_bias_detchar)
dark_class = classification_rule("DARK", {**calib_keywords, kwd.dpr_type: "DARK"})
wave_spec_class = classification_rule(
    "SPEC_CAL", {**calib_keywords, kwd.dpr_type: "WAVE,LAMP"}
)
kappa_matrix_class = classification_rule("KAPPA", rules.is_raw_kappa)
calib_fringe_class = classification_rule(
    "FRINGE", {**vlti_calib_keywords, kwd.dpr_type: "FRINGE,OBJECT"}
)
science_class = classification_rule(
    "FRINGE", {**vlti_science_keywords, kwd.dpr_type: "FRINGE,OBJECT"}
)
int_fringe_class = classification_rule(
    "FRINGE", {**vlti_calib_keywords, kwd.dpr_type: ["FRINGE,LAMP", "FRINGE,MARCEL"]}
)

# Static calibrations
static_mask_class = classification_rule(
    "STATIC_MASK", {**pionier, kwd.pro_catg: "STATIC_MASK"}
)
jsdc_cat_class = classification_rule("JSDC_CAT", {kwd.pro_catg: "JSDC_CAT"})

# Master calibrations
DARK_CALIBRATION = classification_rule(
    "DARK_CALIBRATION", {**pionier, kwd.pro_catg: "DARK_CALIBRATION"}
)
SPECTRAL_CALIBRATION = classification_rule(
    "SPECTRAL_CALIBRATION",
    {**pionier, kwd.pro_catg: "SPECTRAL_CALIBRATION", kwd.object: "WAVE,LAMP"},
)
OBJECT_SPECTRAL_CALIBRATION = classification_rule(
    "SPECTRAL_CALIBRATION",
    {**pionier, kwd.pro_catg: "SPECTRAL_CALIBRATION", kwd.object: "WAVE,OBJECT"},
)
KAPPA_MATRIX = classification_rule(
    "KAPPA_MATRIX", {**pionier, kwd.pro_catg: "KAPPA_MATRIX"}
)
OIDATA_TF = classification_rule("OIDATA_TF", {**pionier, kwd.pro_catg: "OIDATA_TF"})
TARGET_OIDATA_RAW = classification_rule(
    "TARGET_OIDATA_RAW", {kwd.pro_catg: "TARGET_OIDATA_RAW"}
)
