from edps import QC1_CALIB, QC0, SCIENCE, CALCHECKER, ReportInput
from edps import task

from .pionier_datasources import *
from .pionier_monitoring import monitoring

__title__ = "PIONIER workflow"
# Processing tasks

# Detector monitoring tasks
bias_pixchar, detector_monitor = monitoring()

# Task to process dark calibrations.
dark = (task('dark')
        .with_recipe('pioni_dark_calibration')
        .with_report('pionier_dark', ReportInput.RECIPE_INPUTS_OUTPUTS)
        .with_main_input(raw_dark)
        .with_meta_targets([QC1_CALIB])
        .build())

# Task to perform wavelength calibration
wavelength_calibration = (task('wavelength_calibration')
                          .with_recipe('pioni_spectral_calibration')
                          .with_report('pionier_wavelength', ReportInput.RECIPE_INPUTS_OUTPUTS)
                          .with_main_input(raw_wave_spec)
                          .with_meta_targets([QC1_CALIB])
                          .build())

# Task to compute the kappa matrix, i.e. the interferometric transmission,
# that accounts for atmospheric and instrument response.
kappa_matrix = (task('kappa_matrix')
                .with_recipe('pioni_kappa_matrix')
                .with_report('pionier_kappa', ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_kappa_matrix)
                .with_associated_input(dark, [DARK_CALIBRATION], match_rules=match_close_dark)
                .with_meta_targets([QC1_CALIB])
                .build())

# Task to compute the internal visibility of the instruments using fringes from lamps.
# It is used only for monitoring purposes.
interferometric_fringe = (task('lamp_fringes')
                          .with_recipe('pioni_oidata_raw')
                          .with_report('pionier_fringes', ReportInput.RECIPE_INPUTS_OUTPUTS)
                          .with_main_input(raw_int_fringe)
                          .with_associated_input(dark, [DARK_CALIBRATION])
                          .with_associated_input(wavelength_calibration, [SPECTRAL_CALIBRATION],
                                                 match_rules=match_close_wave)
                          .with_associated_input(kappa_matrix, [KAPPA_MATRIX])
                          .with_associated_input(jsdc_cat)
                          .with_meta_targets([QC1_CALIB, CALCHECKER])
                          .build())

# -- Process calibrators ---
# Process calibrators data, extract uncalibrated visibilities.
calibrator_fringes = (task('calibrator_fringes')
                      .with_recipe('pioni_oidata_raw')
                      .with_report('pionier_fringes', ReportInput.RECIPE_INPUTS_OUTPUTS)
                      .with_main_input(raw_calib_fringe)
                      .with_associated_input(dark, [DARK_CALIBRATION])
                      .with_associated_input(wavelength_calibration, [SPECTRAL_CALIBRATION])
                      .with_associated_input(kappa_matrix, [KAPPA_MATRIX])
                      .with_associated_input(jsdc_cat)
                      .with_meta_targets([QC1_CALIB, CALCHECKER])
                      .build())

# Create transfer functions using calibrators and uncalibrated visibilities
transfer_function = (task('transfer_function')
                     .with_recipe("pioni_oidata_tf")
                     .with_report('pionier_tf', ReportInput.RECIPE_INPUTS_OUTPUTS)
                     .with_main_input(calibrator_fringes)
                     .with_associated_input(jsdc_cat)
                     .with_meta_targets([QC1_CALIB])
                     .build())
# ---

# -- Reduction of scientific data. ---
#  Process science data, extract uncalibrated visibilities.
science_fringes = (task('science_fringes')
                   .with_recipe('pioni_oidata_raw')
                   .with_main_input(raw_science)
                   .with_associated_input(dark, [DARK_CALIBRATION], match_rules=match_close_dark)
                   .with_associated_input(wavelength_calibration, [SPECTRAL_CALIBRATION], match_rules=match_close_wave)
                   .with_associated_input(kappa_matrix, [KAPPA_MATRIX])
                   .with_associated_input(jsdc_cat)
                   .with_meta_targets([QC0, SCIENCE, CALCHECKER])
                   .build())

# Calibrate science visibilities using the associated transfer functions derived from calibrators
# and science uncalibrated visibilities.
science_calibrated = (task('science_calibrated')
                      .with_recipe('pioni_oidata_calibrated')
                      .with_main_input(science_fringes)
                      .with_associated_input(transfer_function, [OIDATA_TF], min_ret=1, max_ret=15)
                      .with_meta_targets([SCIENCE])
                      .build())

# ---
