/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_FIBTAB_H
#define QMOST_FIBTAB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_fibtabload (
    const cpl_frame *inframe,
    int shuffle,
    cpl_table **tab,
    cpl_propertylist **hdr);

cpl_error_code qmost_fibtabsave (
    cpl_table *intab,
    cpl_propertylist *inhdr,
    const cpl_frame *outframe);

cpl_error_code qmost_fibtab_dummy (
    int nfib,
    cpl_table **tab,
    cpl_propertylist **hdr);

cpl_error_code qmost_fibtab_newcols (
    cpl_table *in_tbl,
    cpl_propertylist *pri_hdr,
    double exptime,
    double mjdmid,
    cpl_table **out_tbl);

cpl_error_code qmost_fibtab_arcqc (
    cpl_table *fibinfo_tbl,
    int arm,
    cpl_table *master_wave_tbl,
    cpl_table *ob_wave_tbl);

CPL_END_DECLS

#endif  /* QMOST_FIBTAB_H */
